package com.sonicsw.sdf;

import java.io.IOException;

/**
 * ITracer is obtained from IDiagnosticsContext.getTracer() by the IDiagnosticsProvider object. It is used for tracing by the IDiagnosticsProvider object.
 */
public interface ITracer
{
   /**
    * Write a tracing message into the ITracer file
    *
    * @param message to be written to ITracer
    * @param throwable to be written to ITracer
    * @param logTimestamp if 'true' time stamp the trace file entry
    *
    * @exception thrown if write() failed
    */
    public void trace(String message, Throwable throwable, boolean logTimestamp) throws IOException;

   /**
    * Write a tracing message into the ITracer file
    *
    * @param message to be written to ITracer
    * @param logTimestamp if 'true' time stamp the trace file entry
    *
    * @exception thrown if write() failed
    */
    public void trace(String message, boolean logTimestamp) throws IOException;

   /**
    * Returns the path of this file
    *
    * @retrun returns the path of this file
    */
    public String getFilePath();

   /**
    * Closes this file. Should be called dumping the entire state of the IDiagnosticsProvider object
    *
    */
    public void close();
}