package com.sonicsw.sdf;

public final class Version
{
    static final short MAJOR_VERSION = 10;
    static final byte MINOR_VERSION = 0;
    static final byte POINT_VERSION = 7;
    static final int BUILD_NUMBER = 129;

    static final String PRODUCT_NAME = "SDF";

     static String RELEASE_NAME = MAJOR_VERSION + "." + MINOR_VERSION + "." + POINT_VERSION;

    // When this class is run standalone it prints its version data to stdout.
    public static void main(String[] args)
    {
        System.out.println("MAJOR_VERSION=" + MAJOR_VERSION);
        System.out.println("MINOR_VERSION=" + MINOR_VERSION + "." + POINT_VERSION);
        System.out.println("BUILD_NUMBER=" + BUILD_NUMBER);
    }

    public static String getVersionText()
    {
        return "Release " + RELEASE_NAME + " Build Number " + BUILD_NUMBER;
    }

    public static int getMajorVersion()
    {
        return MAJOR_VERSION;
    }

    public static int getMinorVersion()
    {
        return MINOR_VERSION;
    }

    public static String getPointVersion()
    {
        return "" + POINT_VERSION;
    }

    public static int getBuildNumber()
    {
        return BUILD_NUMBER;
    }

    public static String getProductName()
    {
        return PRODUCT_NAME;
    }
}
