package com.sonicsw.sdf.impl;

import java.lang.reflect.Method;

import com.sonicsw.sdf.WriterUtil;


//Generates heap dump for IBM JVMs
public class IBMHeapDump implements com.sonicsw.sdf.IDiagnosticsConstants
{
    private static String DESCRIPTION;

    private static boolean m_heapDumpSupported = true;

    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];


    private static Class Dump_CLASS;
    private static Method HeapDump_METHOD;

    static
    {
        StringBuffer tmp = new StringBuffer();

        tmp.append("The name of the dump file is written to the container log (if running in the MF container) and/or to ").append(NEWLINE);
        tmp.append("the standard output.").append(NEWLINE);
        tmp.append("The 'Using HeapDump' section of the http://download.boulder.ibm.com/ibmdl/pub/software/dw/jdk/diagnosis/diag142.pdf").append(NEWLINE);
        tmp.append("document details the interpretation and use of the heap dump file.");
        DESCRIPTION = tmp.toString();
    }

    static
    {
        try
        {
            Dump_CLASS = Class.forName("com.ibm.jvm.Dump");
            HeapDump_METHOD = Dump_CLASS.getMethod("HeapDump", EMPTY_CLASS_ARRAY);


        }
        catch (Throwable e)
        {
            m_heapDumpSupported = false;
        }

    }

    static String describe()
    {
        StringBuffer tmp = new StringBuffer();
        tmp.append("This JVM generates an IBM JVM heap dump in a text format.").append(NEWLINE);
        tmp.append(DESCRIPTION);
        return tmp.toString();
    }

    static boolean heapDumpSupported()
    {
        return m_heapDumpSupported;
    }

    static void dumpHeap(StringBuffer buffer)
    {
        try
        {
            HeapDump_METHOD.invoke(null, EMPTY_OBJECT_ARRAY);
            buffer.append("Heap dump file was generated. ");
            buffer.append(DESCRIPTION);
        }
        catch(Throwable t)
        {
            buffer.append(JVM_HEAP_SUBSYS).append(" failed to generate a heap dump for the IBM JVM:");
            buffer.append(NEWLINE).append(WriterUtil.getExceptionAsString(t));
        }
    }


}


