package com.sonicsw.sdf.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

import com.sonicsw.sdf.IDiagnosticsConstants;

final class InstructionsFileParser implements IDiagnosticsConstants
{
    public static void main(String argv[]) throws Exception
    {
        ArrayList instructions = parse(new File("inst.txt"));
        for (int i = 0; i < instructions.size(); i++)
        {
            System.out.println(NEWLINE + (Instruction)instructions.get(i));
        }

    }

    static ArrayList parse(String instructions) throws IOException
    {
        BufferedReader reader = new BufferedReader (new StringReader(instructions));
        return parse(reader);
    }

    static ArrayList parse(File instructionsFile) throws IOException
    {
        BufferedReader reader = new BufferedReader (new InputStreamReader(new FileInputStream(instructionsFile)));
        return parse(reader);
    }

    private static ArrayList parse(BufferedReader reader) throws IOException
    {
        ArrayList instructions = new ArrayList();

        while (true)
        {
            String line = reader.readLine();

            if (line == null)
            {
                reader.close();
                return instructions;
            }

            if (line.length() == 0 || line.charAt(0) == '#')
            {
                continue;
            }


            String subsystenName = null;
            String instructionName = null;

            StringTokenizer tokens = new StringTokenizer(line);

            if (!tokens.hasMoreElements())
            {
                continue;
            }

            //The line must contain at least <subsystemName> <operation>
            // If it doesn't we create a "bad" instruction object that only
            // contains the bad line
            subsystenName = (String)tokens.nextToken();
            if (!tokens.hasMoreElements())
            {
                if (subsystenName.equalsIgnoreCase(HELP_OP) || subsystenName.equalsIgnoreCase(HELP1_OP) || subsystenName.equalsIgnoreCase(HELP2_OP))
                {
                    instructions.add(new Instruction(line, SONIC_DIAGNOSTICS_SUBSYS, HELP_OP, new HashMap()));
                }
                else
                {
                    instructions.add(new Instruction(line));
                }
                continue;
            }
            instructionName = (String)tokens.nextToken();


            HashMap parameters = new HashMap();
            while (tokens.hasMoreElements())
            {
                String parameterString = (String)tokens.nextToken();
                int valueIndex = parameterString.indexOf("=");
                String key;
                String value;
                if (valueIndex == -1)
                {
                    key = parameterString;
                    value = value = "";
                }
                else
                {
                    key = parameterString.substring(0, valueIndex);
                    value = parameterString.substring(valueIndex+1);
                }
                parameters.put(key, value);
            }

            instructions.add(new Instruction(line, subsystenName, instructionName, parameters));
        }

    }

    static class Instruction
    {
        private boolean m_syntaxOK;
        private String m_instructionLine;
        private String m_subsystenName;
        private String m_instructionName;
        private HashMap m_parameters;

        Instruction(String instructionLine, String subsystenName, String instructionName, HashMap parameters)
        {
            m_subsystenName = subsystenName;
            m_instructionLine = instructionLine;
            m_instructionName = instructionName;
            m_parameters = parameters;
            m_syntaxOK = true;
        }

        // Constructor for a bad instruction syntax
        Instruction(String instructionLine)
        {
            m_instructionLine = instructionLine;
            m_syntaxOK = false;
        }

        String getSubsystemName()
        {
            return m_subsystenName;
        }

        String getInstructionLine()
        {
            return m_instructionLine;
        }

        String getInstructionName()
        {
            return m_instructionName;
        }

        HashMap getParameters()
        {
            return m_parameters;
        }

        boolean isSyntaxOK()
        {
            return m_syntaxOK;
        }

        @Override
        public String toString()
        {
            if (!m_syntaxOK)
            {
                return "Bad instruction line: " + m_instructionLine;
            }

            StringBuffer buffer = new StringBuffer();
            buffer.append(m_subsystenName).append(" ").append(m_instructionName).append(NEWLINE).append(m_parameters.toString());
            return buffer.toString();
        }

    }
}



