package com.sonicsw.sdf.impl;

import java.util.HashMap;

import com.sonicsw.sdf.AbstractDiagnosticsProvider;
import com.sonicsw.sdf.IDiagnosticsContext;

//Generates heap dump for diagnostics
public class JVMHeapDiagnostics extends AbstractDiagnosticsProvider
{
    private static final String SUPPORTED_LIST = "Heap dump generation requires: IBM JVM 1.4.2 (or higher) or HotSpot JVM 1.6 (or higher)";
    private static final String NOT_SUPPORTED_MESSAGE = "Heap dump generation is not supported by this JVM. ";
    private static String[] OPERATIONS;
    private static HashMap DUMP_STATE_PARAM_DESCIPTOR = new HashMap();
    private static HashMap DESCRIBE_PARAM_DESCIPTOR = new HashMap();
    private static HashMap PARAM_DESCRIPTOR = new HashMap();
    static
    {
        DUMP_STATE_PARAM_DESCIPTOR.put(OP_PARAM_OVERWRITE, OP_PARAM_OVERWRITE_DESCRIPTION + " Default to false");
        DUMP_STATE_PARAM_DESCIPTOR.put(OP_PARAM_OUTPUT_LOCATION, OP_PARAM_OUTPUT_LOCATION_DESCRIPTION);
        DUMP_STATE_PARAM_DESCIPTOR.put(OP_PARAM_FILE_ACCESS, OP_PARAM_FILE_ACCESS_DESCRIPTION + " Default to 'rw-------'");

        PARAM_DESCRIPTOR.put(com.sonicsw.sdf.AbstractDiagnosticsProvider.DUMP_STATE_OP, DUMP_STATE_PARAM_DESCIPTOR);
        PARAM_DESCRIPTOR.put(com.sonicsw.sdf.AbstractDiagnosticsProvider.DESCRIBE_OP, DESCRIBE_PARAM_DESCIPTOR);

        OPERATIONS = com.sonicsw.sdf.AbstractDiagnosticsProvider.toOpnameArray(PARAM_DESCRIPTOR);
    }

    JVMHeapDiagnostics()
    {
        super(JVM_HEAP_SUBSYS);
    }

    void setContext (IDiagnosticsContext diagContext)
    {
        m_diagnosticsContext = diagContext;
    }

    @Override
    public String describe()
    {
        StringBuffer tmp = new StringBuffer();
        tmp.append("Generates diagnostics JVM heap dumps. ").append(SUPPORTED_LIST).append(NEWLINE);
        if (HotSpotHeapDump.heapDumpSupported())
        {
            tmp.append(HotSpotHeapDump.describe());
        }
        else if (IBMHeapDump.heapDumpSupported())
        {
            tmp.append(IBMHeapDump.describe());
        }
        else
        {
            tmp.append(NOT_SUPPORTED_MESSAGE);
        }

        return tmp.toString();
    }

    @Override
    public void appendStateDump(String doiIDNotUsed, HashMap parameters, StringBuffer buffer)
    {
        if (HotSpotHeapDump.heapDumpSupported())
        {
            if(parameters.isEmpty())
            {
                HotSpotHeapDump.dumpHeap(buffer,
                        m_diagnosticsContext);

            }
            else
            {
                HotSpotHeapDump.dumpHeap(buffer,
                        m_diagnosticsContext,
                        parameters);
            }
        }
        else if (IBMHeapDump.heapDumpSupported())
        {
            IBMHeapDump.dumpHeap(buffer);
        }
        else
        {
            buffer.append(NOT_SUPPORTED_MESSAGE).append(SUPPORTED_LIST);
        }
    }

    @Override
    public HashMap describeParameters(String operationName)
    {
        return (HashMap)PARAM_DESCRIPTOR.get(operationName);
    }

    //NOOP
    @Override
    public void updateTraceLevel(String doiID, HashMap parameters, StringBuffer buffer)
    {
    }

    @Override
    public String[] getOperations()
    {
        return OPERATIONS;
    }


}


