/*
 * Copyright (c) 2004 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC SOFTWARE MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. PROGRESS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 *
 * @author Rajiv Kanaujia
 *
 * Revision History
 * Date         Author          Desc
 * ----         ------          ----
 * 2002May29    Rajiv           Defined the class
 *
 */
package com.sonicsw.security.pass.mf;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

import com.sonicsw.util.debug.Debug;


/**
 * This exception is to be thrown by the implementer of Management SPI.
 * <p>
 * If there is any failure in communicating with the external store by the 
 * implementation, this exception should be thrown.
 * <p>
 * @author Rajiv Kanaujia
 */

public class ConnectionException extends Exception {

    /**
     * Default constructor
     */
    public ConnectionException() {
        super();
    }

    /**
     * Constructor
     * <p>
     * @param message error message
     */
    public ConnectionException(String message) {
        super(message);
    }

    /**
     * This constructor prints stack trace on the console. 
     * @param t
     */
    public ConnectionException(Throwable t)
    {
        super(t.getMessage());
        try
        {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(out, true);
            t.printStackTrace(writer);
            byte[] data = out.toByteArray();
            out.close();
            System.out.println(new String(data));
        }
        catch (Exception e)
        {
            if (Debug.TRACE)
            {
                e.printStackTrace();
            }
        }
    }    
}