/*
 * Copyright (c) 2004 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC SOFTWARE MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. PROGRESS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 *
 * @author Rajiv Kanaujia
 *
 * Revision History
 * Date         Author          Desc
 * ----         ------          ----
 * 2002May29    Rajiv           Defined the interface
 *
 */
package com.sonicsw.security.pass.mf;


/**
 * When the Management SPI gets disconnected with the underlying external 
 * security store, this event is used to notify the Sonic runtime about such 
 * fatalities.
 * <p>
 * @author Rajiv Kanaujia
 */
public interface IEventDisconnected
    extends IEvent {

    /**
     * This method is used to get error message associated with the event.
     * <p>
     * @return the error message
     */
    public String getErrorMessage();


    /**
     * This method is used to get error code associated with the event.
     * <p>
     * @return the error code
     */
    public int getErrorCode();

}