/*
 * Copyright (c) 2004 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC SOFTWARE MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. PROGRESS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 *
 * @author Rajiv Kanaujia
 *
 * Revision History
 * Date         Author          Desc
 * ----         ------          ----
 * 2002May14    Rajiv           Defined the interface
 *
 */
package com.sonicsw.security.pass.mf;

import com.sonicsw.security.pass.client.IPasswordUser;

/**
 * This class defines an external group. It consists of group name that 
 * can be used to uniquely identify the group. It can contain users that 
 * are members of this group, called group members.
 * <p>
 * @see com.sonicsw.security.pass.mf.IManagement#getGroups()
 * <p>
 * @author Rajiv Kanaujia
 */
public interface IGroup
{

    /**
     * This method is used to retrieve the name of the group that can be used to 
     * uniquely identify this group.
     * <p>
     * @return the name of the group.
     */
    public String getName();

    /**
     * This method returns a list of users belonging to this group.
     * <p>
     * @return group members
     */
    // TODO rajiv Should all operations to the external security store throw 
    // connection exception?
    public IPasswordUser[] getGroupUsers();
}