/*
 * Copyright (c) 2004 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC SOFTWARE MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. PROGRESS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 *
 * @author Rajiv Kanaujia
 *
 * Revision History
 * Date         Author          Desc
 * ----         ------          ----
 * 2002May29    Rajiv           Defined the interface
 *
 */
package com.sonicsw.security.pass.mf;


/**
 * Management SPI configured in the Authentication Domain has attributes setting 
 * group box through which the attributes (name-value pair) are defined for the 
 * Management SPI. These attributes are passed to the Management SPI 
 * implementation in the <code>connect</code> method.
 * <p>
 * If the connection fails due to bad attributes, this exception should be thrown.
 * <p>
 * @see com.sonicsw.security.pass.mf.IManagement#connect(HashMap)
 * <p>
 * @author Rajiv Kanaujia
 */
public class InvalidConfigurationException
    extends ConnectionException {

    /**
     * Default Constructor
     */
    public InvalidConfigurationException() {
        super();
    }

    /**
     * Constructor
     * <p>
     * @param message error message
     */
    public InvalidConfigurationException(String message) {
        super(message);
    }

}