/* ========================================================================
 *
 * The ModelObjects Group Software License, Version 1.0
 *
 *
 * Copyright (c) 2000-2001 ModelObjects Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        ModelObjects Group (http://www.modelobjects.com)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The name "ModelObjects" must not be used to endorse or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact djacobs@modelobjects.com.
 *
 * 5. Products derived from this software may not be called "ModelObjects",
 *    nor may "ModelObjects" appear in their name, without prior written
 *    permission of the ModelObjects Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE MODEL OBJECTS GROUP OR ITS
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ========================================================================
 */

package modelobjects.framework;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import modelobjects.framework.model.ModelAspectId;


/**
 *  This class is used for ViewAspectAdapters that should only be
 *  editable when another aspect the model has a particular value
 *  or values.
 */
public class DependentFieldEditRule extends EditRule
  implements ChangeListener
{
  public DependentFieldEditRule(ModelEditMediator editMediator,
                                ModelAspectId dependsOnAspectId,
                                Object dependsOnAspectValue)
  {
    this(editMediator, dependsOnAspectId, dependsOnAspectValue, true);
  }

  public DependentFieldEditRule(ModelEditMediator editMediator,
                                ModelAspectId dependsOnAspectId,
                                Object[] dependsOnAspectValues)
  {
    this(editMediator, dependsOnAspectId, dependsOnAspectValues, false);
  }

  private DependentFieldEditRule(ModelEditMediator editMediator,
                                 ModelAspectId dependsOnAspectId,
                                 Object dependsOnAspectValue,
                                 boolean singleValue)
  {
    this.editMediator           = editMediator;
    this.dependsOnAspectId      = dependsOnAspectId;
    this.dependsOnAspectValue   = dependsOnAspectValue;
    this.singleValue            = singleValue;
    this.useViewAspectAdapter   = true;
  }


  @Override
public boolean isEditableInEditor(ViewAspectAdapter viewAspectAdapter,
                                    ModelEditMediator modelEditMediator)
  {
    if (modelEditMediator != editMediator)
    {
        throw(new IllegalArgumentException("wrong ModelEditMediator"));
    }

    if ((dependsOnViewAspectAdapter == null) && useViewAspectAdapter) {
      dependsOnViewAspectAdapter =
        editMediator.getViewAspectAdapter(dependsOnAspectId);

      if (dependsOnViewAspectAdapter != null) {
        // there is a ViewAspectAdapter for the field we depend on,
        // so listen for when it changes
        dependsOnViewAspectAdapter.addChangeListener(this);
      }
      else {
        useViewAspectAdapter = false;
      }
    }

    try {
      Object currentAspectValue = 
        ((dependsOnViewAspectAdapter != null) ?
         dependsOnViewAspectAdapter.getModelAspectValue() :
         editMediator.getModel().getAspectValue(dependsOnAspectId));

      if (singleValue) {
        return((dependsOnAspectValue == currentAspectValue) ||
               ((dependsOnAspectValue != null) &&
                dependsOnAspectValue.equals(currentAspectValue)));
      }
      else {
        Object[] values = (Object[])dependsOnAspectValue;
        for (int i = 0, n = values.length; i < n; i++) {
          Object value = values[i];
          if ((value == currentAspectValue) ||
              ((value != null) && value.equals(currentAspectValue)))
        {
            return(true);
        }
        }
      }
    }
    catch (Exception e) {
      // forget it, we lose
    }

    return(false);
  }

  /**
   *  Whenever the field we depend on changes its value, recompute editability
   *  on the whole form.
   */
  @Override
public void stateChanged(ChangeEvent event)
  {
    editMediator.recomputeEditability();
  }

  /////////////////////////////////////////////////////////////////////////////
  ///
  ///  representation
  ///
  /////////////////////////////////////////////////////////////////////////////

  private ModelEditMediator     editMediator;
  private ModelAspectId         dependsOnAspectId;
  private Object                dependsOnAspectValue;
  private boolean               singleValue;

  private ViewAspectAdapter     dependsOnViewAspectAdapter;
  private boolean               useViewAspectAdapter;
}
