/* ========================================================================
 *
 * The ModelObjects Group Software License, Version 1.0
 *
 *
 * Copyright (c) 2000-2001 ModelObjects Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        ModelObjects Group (http://www.modelobjects.com)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The name "ModelObjects" must not be used to endorse or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact djacobs@modelobjects.com.
 *
 * 5. Products derived from this software may not be called "ModelObjects",
 *    nor may "ModelObjects" appear in their name, without prior written
 *    permission of the ModelObjects Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE MODEL OBJECTS GROUP OR ITS
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ========================================================================
 */

package modelobjects.framework;

/**
 *  This class is used by ModelEditMediators to determine which
 *  ViewAspectAdapters should be editable and which should be uneditable.
 */
public abstract class EditRule
{
  /**
   *  Return whether the specified ViewAspectAdapter should be editable
   *  in the specified ModelEditMediator.  It is assumed that the
   *  ViewAspectAdapter is managed by the ModelEditMediator.
   *  This default implementation always return true.
   */
  public abstract boolean isEditableInEditor
    (ViewAspectAdapter viewAspectAdapter, ModelEditMediator modelEditMediator);

  private static class AlwaysEditable extends EditRule
  {
    @Override
    public boolean isEditableInEditor(ViewAspectAdapter viewAspectAdapter,
                                      ModelEditMediator modelEditMediator)
    {
      return(true);
    }
  }

  private static class NeverEditable extends EditRule
  {
    @Override
    public boolean isEditableInEditor(ViewAspectAdapter viewAspectAdapter,
                                      ModelEditMediator modelEditMediator)
    {
      return(false);
    }
  }

  private static class EditableForInit extends EditRule
  {
    @Override
    public boolean isEditableInEditor(ViewAspectAdapter viewAspectAdapter,
                                      ModelEditMediator modelEditMediator)
    {
      return(modelEditMediator.getEditModelAsNewObject());
    }
  }

  /**
   *  This EditRule is used for aspects that are always editable.
   */
  public static EditRule ALWAYS         = new AlwaysEditable();

  /**
   *  This EditRule is used for aspects that are never editable.
   */
  public static EditRule NEVER          = new NeverEditable();

  /**
   *  This EditRule is used for aspects that are only editable if the
   *  model object is being edited for intialization as a new object.
   */
  public static EditRule FOR_INIT       = new EditableForInit();
}
