/* ========================================================================
 *
 * The ModelObjects Group Software License, Version 1.0
 *
 *
 * Copyright (c) 2000-2001 ModelObjects Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        ModelObjects Group (http://www.modelobjects.com)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The name "ModelObjects" must not be used to endorse or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact djacobs@modelobjects.com.
 *
 * 5. Products derived from this software may not be called "ModelObjects",
 *    nor may "ModelObjects" appear in their name, without prior written
 *    permission of the ModelObjects Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE MODEL OBJECTS GROUP OR ITS
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ========================================================================
 */


package modelobjects.framework;

import java.util.EventObject;

/**
 *  ModelEditEvents are fired to ModelEditListeners whenever an apply
 *  occurs, or whenever an apply is undone or redone.
 */
public class ModelEditEvent extends EventObject
{
  /**
   *  Construct a ModelEditEvent for the specified event-source, and
   *  with the specified eventID, which is one of {APPLY, UNDO, or REDO}.
   *
   *  The event indicates a change to the specified model-object, and
   *  indicates whether the model-object was being edited as a new
   *  object at the time of the apply.
   */
  public ModelEditEvent(Object eventSource, int eventID,
                        Object modelObject, boolean wasNew)
  {
    super(eventSource);
    this.eventID     = eventID;
    this.modelObject = modelObject;
    this.wasNew      = wasNew;
  }

  /**
   *  Return the ModelObjectAdapter that this ModelEditEvent is about.
   */
  public Object getModelObject()
  {
    return(modelObject);
  }

  /**
   *  Return whether the model-object was being edited as new.
   */
  public boolean getObjectWasNew()
  {
    return(wasNew);
  }

  /**
   *  Return this ModelEditEvent's eventID, which will be one of
   *  APPLY, UNDO, or REDO.
   */
  public int getEventID()
  {
    return(eventID);
  }

  /**
   *  The following constants indicate what sort of action precipitated
   *  the event.
   */
  public static final int CREATE = 1;
  public static final int APPLY  = 2;
  public static final int UNDO   = 3;
  public static final int REDO   = 4;
  public static final int DELETE = 5;

  private Object  modelObject;
  private int     eventID;
  private boolean wasNew;
}
