package modelobjects.framework;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import modelobjects.framework.model.ModelAspectId;

public class MultipleAspectDependentEditRule extends EditRule
    implements ChangeListener
{

    public MultipleAspectDependentEditRule(ModelEditMediator editMediator,
                                    ModelAspectId[] dependsOnAspectIds,
                                    Object[] dependsOnAspectValues)
    {
        this.editMediator           = editMediator;
        this.dependsOnAspectIds      = dependsOnAspectIds;
        this.dependsOnAspectValues   = dependsOnAspectValues;
        this.useViewAspectAdapters   = new boolean[dependsOnAspectIds.length];
        for (int i=0; i<dependsOnAspectIds.length; i++)
        {
            this.useViewAspectAdapters[i] = true;
        }
        this.dependsOnViewAspectAdapters = new ViewAspectAdapter[dependsOnAspectIds.length];
    }


    @Override
    public boolean isEditableInEditor(ViewAspectAdapter viewAspectAdapter,
                                    ModelEditMediator modelEditMediator)
    {
        if (modelEditMediator != editMediator)
        {
            throw(new IllegalArgumentException("wrong ModelEditMediator"));
        }


        for (int i=0; i< dependsOnAspectIds.length; i++)
        {
            if ((dependsOnViewAspectAdapters[i] == null) && useViewAspectAdapters[i])
            {
                dependsOnViewAspectAdapters[i] =
                    editMediator.getViewAspectAdapter(dependsOnAspectIds[i]);

                if (dependsOnViewAspectAdapters[i] != null)
                {
                    // there is a ViewAspectAdapter for the field we depend on,
                        // so listen for when it changes
                    dependsOnViewAspectAdapters[i].addChangeListener(this);
                }
            }
            else
            {
                useViewAspectAdapters[i] = false;
            }
        }

        try
        {
            for (int i=0; i< dependsOnAspectIds.length; i++)
            {
                Object currentAspectValue =
                    ((dependsOnViewAspectAdapters[i] != null) ?
                    dependsOnViewAspectAdapters[i].getModelAspectValue() :
                    editMediator.getModel().getAspectValue(dependsOnAspectIds[i]));

                if ( ! ((dependsOnAspectValues[i] == currentAspectValue) ||
                    ((dependsOnAspectValues[i] != null) &&
                        dependsOnAspectValues[i].equals(currentAspectValue))) )
                {
                    return false;
                }
            }
        }
        catch (Exception e)
        {
      // forget it, we lose
        }
        return(true);
    }

  /**
   *  Whenever the field we depend on changes its value, recompute editability
   *  on the whole form.
   */
  @Override
public void stateChanged(ChangeEvent event)
  {
    editMediator.recomputeEditability();
  }

  /////////////////////////////////////////////////////////////////////////////
  ///
  ///  representation
  ///
  /////////////////////////////////////////////////////////////////////////////

  private ModelEditMediator       editMediator;
  private ModelAspectId[]         dependsOnAspectIds;
  private Object[]                dependsOnAspectValues;


  private ViewAspectAdapter[]     dependsOnViewAspectAdapters;
  private boolean[]               useViewAspectAdapters;
}