/* ========================================================================
 *
 * The ModelObjects Group Software License, Version 1.0
 *
 *
 * Copyright (c) 2000-2001 ModelObjects Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        ModelObjects Group (http://www.modelobjects.com)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The name "ModelObjects" must not be used to endorse or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact djacobs@modelobjects.com.
 *
 * 5. Products derived from this software may not be called "ModelObjects",
 *    nor may "ModelObjects" appear in their name, without prior written
 *    permission of the ModelObjects Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE MODEL OBJECTS GROUP OR ITS
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ========================================================================
 */
package modelobjects.framework.swing;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JCheckBox;

import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewAspectAdapter;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;

public class JCheckBoxAdapter extends ViewAspectAdapter
  implements ItemListener
{
  public JCheckBoxAdapter(ModelAspectId modelAspectId,
                          JCheckBox viewComponent)
  {
    super(modelAspectId);
    viewComponent.setName(modelAspectId.toString());
    setViewComponent(viewComponent);
  }

  public JCheckBoxAdapter(ModelAspectId modelAspectId,
                          JCheckBox viewComponent,
                          EditRule editRule,
                          ViewValueConverter viewValueConverter,
                          ModelEditMediator modelEditMediator)
  {
    this(modelAspectId, viewComponent, editRule, viewValueConverter, modelEditMediator, false);
  }

  public JCheckBoxAdapter(ModelAspectId modelAspectId,
                          JCheckBox viewComponent,
                          EditRule editRule,
                          ViewValueConverter viewValueConverter,
                          ModelEditMediator modelEditMediator,
                          boolean fireAction)
  {
    super(modelAspectId, editRule, viewValueConverter, modelEditMediator);
    viewComponent.setName(modelAspectId.toString());
    setViewComponent(viewComponent);
    setFireAction(fireAction);
  }

  private void setViewComponent(JCheckBox viewComponent)
  {
    this.viewComponent = viewComponent;
    viewComponent.addItemListener(this);
  }

  @Override
public Component getViewComponent()
  {
    return(viewComponent);
  }

  private void setFireAction(boolean fireAction)
  {
    this.fireAction = fireAction;
  }

  public boolean getFireAction()
  {
    return(fireAction);
  }

  @Override
public boolean isEditable()
  {
    return(viewComponent.isEnabled());
  }

  @Override
public void setEditable(boolean editable)
  {
    viewComponent.setEnabled(editable);
  }

  @Override
public Object getViewAspectValue()
  {
    return(viewComponent.isSelected() ? Boolean.TRUE : Boolean.FALSE);
  }

  @Override
public String getViewAspectStringValue()
  {
    return(viewComponent.isSelected() ? "true" : "false");
  }

  @Override
protected void setViewAspectValue(Object viewAspectValue)
    throws IllegalArgumentException
  {
    boolean value = false;

    if (viewAspectValue == null)
    {
        value = false;
    }
    else if (viewAspectValue instanceof Boolean)
    {
        value = ((Boolean)viewAspectValue).booleanValue();
    }
    else
    {
        throw(new IllegalArgumentException("value must be boolean"));
    }

    if (viewComponent.isSelected() != value)
    {
      if (fireAction)
    {
        viewComponent.doClick();
    }
    else
    {
        viewComponent.setSelected(value);
    }
    }
  }

  @Override
protected void setViewAspectStringValue(String viewStringValue)
    throws IllegalArgumentException
  {
    boolean value = "true".equals(viewStringValue);
    setViewAspectValue(new Boolean(value));
  }

  ///  ItemListener interface methods

  @Override
public void itemStateChanged(ItemEvent event)
  {
    fireChangeEvent();
  }

  private JCheckBox viewComponent;
  private boolean fireAction = false;
}
