package modelobjects.framework.swing;

import java.awt.Component;
import java.lang.reflect.Array;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewAspectAdapter;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.model.ModelAspectId;

public class JListViewAspectAdapter extends ViewAspectAdapter
                                    implements ListDataListener
{
  public JListViewAspectAdapter(ModelAspectId aspectId,
                                JList         viewComponent,
                                Class         arrayElementType)
  {
    this(aspectId, viewComponent, arrayElementType, null, null);
  }

  public JListViewAspectAdapter(ModelAspectId     aspectId,
                                JList             viewComponent,
                                Class             arrayElementType,
                                EditRule          editRule,
                                ModelEditMediator modelEditMediator)
  {
    super(aspectId, editRule, null, modelEditMediator);
    viewComponent.setName(aspectId.toString());
    this.viewComponent = viewComponent;
    viewComponent.getModel().addListDataListener(this);
    this.arrayElementType = arrayElementType;
  }

  @Override
public Component getViewComponent()
  {
    return viewComponent;
  }

  /**
   *  Return the model aspect value.
   */
  @Override
public  Object getModelAspectValue()
    throws ViewValueConversionException
  {
    ListModel listModel = viewComponent.getModel();
    int size = listModel.getSize();
    Object[] result = (Object[])Array.newInstance(arrayElementType, size);
    for (int i = 0; i < size; i++) {
      result[i] = listModel.getElementAt(i);
    }
    return(result);
  }

  /**
   *  Return the view value.
   */
  @Override
public Object getViewAspectValue()
  {
    return viewComponent.getModel();
  }

  /**
   *  Set the value for the view, which must be an array.
   */
  @Override
public void setViewAspectValue(Object value)
  {
    Object[] items = (Object[])value;
    int size = ((items == null) ? 0 : items.length);
    DefaultListModel listModel = (DefaultListModel)viewComponent.getModel();
    listModel.clear();
    for (int i = 0; i < size; i++) {
      listModel.addElement(items[i]);
    }
    viewComponent.setModel(listModel);
  }

  @Override
public String getViewAspectStringValue()
  {
    throw new UnsupportedOperationException();
  }

  @Override
public void setViewAspectStringValue(String stringValue)
  {
    throw new UnsupportedOperationException();
  }

  @Override
public void setEditable(boolean editable)
  {
    viewComponent.setEnabled(editable);
  }

  @Override
public boolean isEditable()
  {
    return viewComponent.isEnabled();
  }

  @Override
public void contentsChanged(ListDataEvent e) {
    fireChangeEvent();
  }
  @Override
public void intervalAdded(ListDataEvent e) {
    fireChangeEvent();
  }
  @Override
public void intervalRemoved(ListDataEvent e) {
    fireChangeEvent();
  }

  protected Object[] assignedViewAspectValue;
  protected Class    arrayElementType;
  protected JList    viewComponent;
}
