package modelobjects.framework.swing;

import javax.swing.JPasswordField;

import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;

/**
 *
 */
public class JPasswordFieldAdapter extends JTextFieldAdapter
{
    /**
     *
     */
    public JPasswordFieldAdapter(ModelAspectId modelAspectId,JPasswordField
        viewComponent,EditRule editRule,ViewValueConverter viewValueConverter,
        ModelEditMediator modelEditMediator)
    {
        super(modelAspectId,viewComponent,editRule,viewValueConverter,modelEditMediator);
        viewComponent.setName(modelAspectId.toString());
    }

    /**
     *
     */
    @Override
    public Object getViewAspectValue()
    {
        char[] password = ((JPasswordField)getViewComponent()).getPassword();
        String passwordString = new String(password);
        return(passwordString.getBytes());
    }

    /**
     *
     */
    @Override
    public String getViewAspectStringValue()
    {
        char[] password = ((JPasswordField)getViewComponent()).getPassword();
        String passwordString = new String(password);
        return(passwordString);
    }

    /**
     *
     */
    @Override
    protected void setViewAspectValue(Object viewAspectValue)
        throws IllegalArgumentException
    {
        if (viewAspectValue == null)
        {
            ((JPasswordField)getViewComponent()).setText("");
        }
        else if (viewAspectValue instanceof String)
        {
            ((JPasswordField)getViewComponent()).setText((String)viewAspectValue);
        }
        else if (viewAspectValue instanceof byte[])
        {
            ((JPasswordField)getViewComponent()).setText(new String((byte[])viewAspectValue));
        }
        else
        {
            throw(new IllegalArgumentException("value must be a String or byte[]: " +
                getModelAspectId()));
        }
    }
}