/* ========================================================================
 *
 * The ModelObjects Group Software License, Version 1.0
 *
 *
 * Copyright (c) 2000-2001 ModelObjects Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        ModelObjects Group (http://www.modelobjects.com)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The name "ModelObjects" must not be used to endorse or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact djacobs@modelobjects.com.
 *
 * 5. Products derived from this software may not be called "ModelObjects",
 *    nor may "ModelObjects" appear in their name, without prior written
 *    permission of the ModelObjects Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE MODEL OBJECTS GROUP OR ITS
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ========================================================================
 */
package modelobjects.framework.swing;

import java.awt.Component;

import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewAspectAdapter;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;

public class JTextFieldAdapter extends ViewAspectAdapter
  implements DocumentListener, UndoableEditListener
{
  public JTextFieldAdapter(ModelAspectId modelAspectId,
                           JTextField viewComponent)
  {
    this(modelAspectId, viewComponent, false);
  }

  public JTextFieldAdapter(ModelAspectId modelAspectId,
                           JTextField viewComponent,
                           boolean fireUndoableTextEvents)
  {
    super(modelAspectId);
    this.fireUndoableTextEvents = fireUndoableTextEvents;
    setViewComponent(viewComponent);
  }

  public JTextFieldAdapter(ModelAspectId modelAspectId,
                           JTextField viewComponent,
                           EditRule editRule,
                           ViewValueConverter viewValueConverter,
                           ModelEditMediator modelEditMediator)
  {
    this(modelAspectId, viewComponent, editRule, viewValueConverter,
         modelEditMediator, false);
  }

  public JTextFieldAdapter(ModelAspectId modelAspectId,
                           JTextField viewComponent,
                           EditRule editRule,
                           ViewValueConverter viewValueConverter,
                           ModelEditMediator modelEditMediator,
                           boolean fireUndoableTextEvents)
  {
    super(modelAspectId, editRule, viewValueConverter, modelEditMediator);
    viewComponent.setName(modelAspectId.toString());
    this.fireUndoableTextEvents = fireUndoableTextEvents;
    setViewComponent(viewComponent);
  }

  private void setViewComponent(JTextField viewComponent)
  {
    this.viewComponent = viewComponent;
    viewComponent.getDocument().addDocumentListener(this);
    if (fireUndoableTextEvents)
    {
        viewComponent.getDocument().addUndoableEditListener(this);
    }
  }

  @Override
public final Component getViewComponent()
  {
    return(viewComponent);
  }

  @Override
public boolean isEditable()
  {
    return(viewComponent.isEditable());
  }

  @Override
public void setEditable(boolean editable)
  {
    if (editable != viewComponent.isEditable()) {
      viewComponent.setEditable(editable);
      viewComponent.setBackground(editable ?
                                  UIManager.getColor("TextField.background") :
                                  UIManager.getColor("Panel.background"));
/*
      viewComponent.setBorder(editable ?
                              UIManager.getBorder("TextField.border") :
                              BorderFactory.createEmptyBorder(2,1,2,1));
*/
    }
  }

  @Override
public Object getViewAspectValue()
  {
    return(viewComponent.getText());
  }

  @Override
public String getViewAspectStringValue()
  {
    return(viewComponent.getText());
  }

  @Override
protected void setViewAspectValue(Object viewAspectValue)
    throws IllegalArgumentException
  {
    if (viewAspectValue == null)
    {
        viewComponent.setText("");
    }
    else if (viewAspectValue instanceof String)
    {
        viewComponent.setText((String)viewAspectValue);
    }
    else
    {
        throw(new IllegalArgumentException("value must be a String: " +
                                             getModelAspectId()));
    }
  }

  @Override
protected void setViewAspectStringValue(String viewStringValue)
    throws IllegalArgumentException
  {
    if (viewStringValue == null)
    {
        viewComponent.setText("");
    }
    else
    {
        viewComponent.setText(viewStringValue);
    }
  }

  ///  DocumentListener interface methods

  @Override
public void changedUpdate(DocumentEvent event)
  {
    fireChangeEvent();
  }

  @Override
public void insertUpdate(DocumentEvent event)
  {
    fireChangeEvent();
  }

  @Override
public void removeUpdate(DocumentEvent event)
  {
    fireChangeEvent();
  }

  @Override
public void undoableEditHappened(UndoableEditEvent edit)
  {
    if (fireUndoableTextEvents)
    {
        fireUndoableEditEvent(edit.getEdit());
    }
  }

  private JTextField viewComponent;
  private boolean    fireUndoableTextEvents;
}
