package modelobjects.framework.threads;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;

import modelobjects.framework.swing.StatusBar;

public class CancellableThreadTest extends JFrame
  implements ActionListener
{
  private CancellableThreadManager threadMgr;

  public CancellableThreadTest()
  {
    super("CancellableThreadTest");
    prepareCancellableThreadTest();
  }
  
  private void prepareCancellableThreadTest() {
      
    setDefaultCloseOperation(EXIT_ON_CLOSE);

    threadMgr = new CancellableThreadManager();
    JButton cancelButton = new JButton(threadMgr.getCancelAllAction());
    StatusBar statusBar = new StatusBar(cancelButton);
    statusBar.setProgressBarTracksCancelButton(true);

    JButton startButton = new JButton("Start");
    startButton.addActionListener(this);

    getContentPane().setLayout(new BorderLayout(8, 8));
    getContentPane().add(startButton, BorderLayout.WEST);
    getContentPane().add(statusBar,   BorderLayout.SOUTH);

    setBounds(300, 300, 700, 200);
    addNotify();
    validate();
  }

  @Override
public void actionPerformed(ActionEvent event)
  {
    CancellableThread thread =
      threadMgr.createCancellableThread(new FiboPrinter(), "FiboThread");
    thread.start();
  }

  public static void main(String[] args)
  {
    (new CancellableThreadTest()).setVisible(true);
  }

  class FiboPrinter implements Runnable
  {
    @Override
    public void run()
    {
      long a = 0;
      long b = 1;

      for (int i = 0; i < 2000; i++) {
        // check to see if we've been cancelled
        if (CancellableThread.isThreadCancelled())
        {
            break;
        }

        long n = a + b;

        System.out.println("Fibo[" + i + "] = " + a);
        a = b;
        b = n;
      }
    }
  }

}
