/* ========================================================================
 *
 * The ModelObjects Group Software License, Version 1.0
 *
 *
 * Copyright (c) 2000-2001 ModelObjects Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        ModelObjects Group (http://www.modelobjects.com)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The name "ModelObjects" must not be used to endorse or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact djacobs@modelobjects.com.
 *
 * 5. Products derived from this software may not be called "ModelObjects",
 *    nor may "ModelObjects" appear in their name, without prior written
 *    permission of the ModelObjects Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE MODEL OBJECTS GROUP OR ITS
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ========================================================================
 */


package modelobjects.util;

/**
 *  This interface defines the token type constants used by the Lexer.
 *
 *  @author Dan Jacobs  --  ModelObjects Group
 */
public interface LexerTokenTypes
{
  public static final int EOF             = -1;
  public static final int LINE_LITERAL    = -2;

  public static final int IDENTIFIER      = -10;
  public static final int DBL_QUOTE_STR   = -11;
  public static final int SNGL_QUOTE_STR  = -12;
  public static final int INTEGER         = -13;
  public static final int FLOAT           = -14;
  public static final int HEX_INTEGER     = -15;

  public static final int SNGL_EQUALS     = -20;
  public static final int DBL_EQUALS      = -21;
  public static final int NE              = -22;
  public static final int LT              = -23;
  public static final int GT              = -24;
  public static final int LE              = -25;
  public static final int GE              = -26;
  public static final int LTGT            = -27;

  public static final int PLUS            = -30;
  public static final int MINUS           = -31;
  public static final int TIMES           = -32;
  public static final int DIVIDE          = -33;
  public static final int LSH             = -34;
  public static final int RSH             = -35;

  public static final int LPAR            = -40;
  public static final int RPAR            = -41;
  public static final int LBRACE          = -42;
  public static final int RBRACE          = -43;
  public static final int LSQUARE         = -44;
  public static final int RSQUARE         = -45;

  public static final int DOT             = -50;
  public static final int COMMA           = -51;
  public static final int COLON           = -52;
  public static final int SEMICOLON       = -53;
  public static final int ATSIGN          = -54;
  public static final int QUESTION        = -55;
  public static final int SHARP           = -56;
  public static final int PERCENT         = -57;
  public static final int CARET           = -58;
  public static final int DOLLAR          = -59;

  public static final int SNGL_AND        = -60;
  public static final int SNGL_OR         = -61;
  public static final int DBL_AND         = -62;
  public static final int DBL_OR          = -63;
  public static final int NOT             = -64;
  public static final int TILDE           = -65;
}

