/* ========================================================================
 *
 * The ModelObjects Group Software License, Version 1.0
 *
 *
 * Copyright (c) 2000-2001 ModelObjects Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        ModelObjects Group (http://www.modelobjects.com)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The name "ModelObjects" must not be used to endorse or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact djacobs@modelobjects.com.
 *
 * 5. Products derived from this software may not be called "ModelObjects",
 *    nor may "ModelObjects" appear in their name, without prior written
 *    permission of the ModelObjects Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE MODEL OBJECTS GROUP OR ITS
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ========================================================================
 */

package modelobjects.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;


public class LightweightEventSupport
{
  public LightweightEventSupport()
  {
    this(null);
  }

  public LightweightEventSupport(Object owner)
  {
    this.owner = owner;
    listeners = null;
  }

  public boolean anyListeners()
  {
    return((listeners != null) && (!listeners.isEmpty()));
  }

  public int getNumListeners()
  {
    return((listeners == null) ? 0 : listeners.size());
  }

  public Object getOwner()
  {
    return(owner);
  }

  public synchronized void addEventListener(EventListener listener)
  {
    Vector v = ((listeners == null) ? new Vector(2) :
                (Vector)listeners.clone());
    if (!v.contains(listener))
      {
        v.addElement(listener);
        listeners = v;
      }
  }

  public synchronized void removeEventListener(EventListener listener)
  {
    if ((listeners != null) && listeners.contains(listener))
      {
        Vector v = (Vector)listeners.clone();
        v.removeElement(listener);
        listeners = v;
      }
  }

  public void fireEvent(Class listenerInterface,
                        String listenerMethodName,
                        EventObject evt)
  {
    Vector listeners = this.listeners;
    if ((listeners == null) || (listeners.isEmpty()))
    {
        return;
    }

    Class paramTypes[] = { evt.getClass() };

    try {
      Method listenerMethod =
        lookupMethod(listenerInterface, listenerMethodName, paramTypes);
      fireEvent(listeners, listenerMethod, evt);
    }
    catch (NoSuchMethodException noSuchMethod) {
      noSuchMethod.printStackTrace();
    }
  }

  private Method lookupMethod(Class listenerInterface,
                              String listenerMethodName,
                              Class paramTypes[])
    throws NoSuchMethodException
  {
    Method m = (Method)HashtableLazyHolder.METHOD_CACHE.get(listenerMethodName);

    if ((m == null) || (m.getDeclaringClass() != listenerInterface))
      {
        m = listenerInterface.getMethod(listenerMethodName, paramTypes);
        HashtableLazyHolder.METHOD_CACHE.put(listenerMethodName, m);
      }

    return(m);
  }

  private void fireEvent(Vector listeners,
                         Method listenerMethod,
                         EventObject evt)
  {
    Object args[] = { evt };

    for (int i = 0, n = listeners.size(); i < n; i++)
      {
        try {
          listenerMethod.invoke(listeners.elementAt(i), args);
        }
        catch (IllegalAccessException e1) {
          e1.printStackTrace();
        }
        catch (InvocationTargetException e2) {
          e2.getTargetException().printStackTrace();
        }
      }
  }

  private static class HashtableLazyHolder {
      private static final Hashtable METHOD_CACHE = new Hashtable();
  }
  private           Object    owner;
  private transient Vector    listeners;
}
