/* ========================================================================
 *
 * The ModelObjects Group Software License, Version 1.0
 *
 *
 * Copyright (c) 2000-2001 ModelObjects Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        ModelObjects Group (http://www.modelobjects.com)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The name "ModelObjects" must not be used to endorse or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact djacobs@modelobjects.com.
 *
 * 5. Products derived from this software may not be called "ModelObjects",
 *    nor may "ModelObjects" appear in their name, without prior written
 *    permission of the ModelObjects Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE MODEL OBJECTS GROUP OR ITS
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ========================================================================
 */

package modelobjects.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;

/**
 *  ReverseComparator implements reverse-sort comparison in terms of
 *  another Comparator.
 */
public class ReverseComparator implements Comparator, Serializable
{
  /**
   *  Return a Comparator that sorts things in the reverse order as the
   *  specified Compartor.
   */
  public static Comparator makeReverseComparator(Comparator comparator)
  {
    if (comparator instanceof ReverseComparator)
    {
        return(((ReverseComparator)comparator).baseComparator);
    }
    else
    {
        return(new ReverseComparator(comparator));
    }
  }

  /**
   *  Return whether the two specified comparators are inverses of each other.
   */
  public static boolean areInverses(Comparator c1, Comparator c2)
  {
    if (c1 instanceof ReverseComparator)
    {
        return(((ReverseComparator)c1).baseComparator.equals(c2));
    }
    else if (c2 instanceof ReverseComparator)
    {
        return(((ReverseComparator)c2).baseComparator.equals(c1));
    }
    else
    {
        return(false);
    }
  }

  @Override
public int compare(Object a, Object b)
  {
    return(- baseComparator.compare(a, b));
  }

  @Override
public boolean equals(Object obj)
  {
	if (obj == null || this.getClass() != obj.getClass())
    {
        return false;
    }
	if (obj == this)
    {
        return true;
    }
    return baseComparator.equals(((ReverseComparator)obj).baseComparator);
  }
  
  @Override
public int hashCode() {
      return Objects.hashCode(baseComparator);
  }

  private ReverseComparator(Comparator baseComparator)
  {
    this.baseComparator = baseComparator;
  }

  private Comparator baseComparator;
}
