/* ========================================================================
 *
 * The ModelObjects Group Software License, Version 1.0
 *
 *
 * Copyright (c) 2000-2001 ModelObjects Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        ModelObjects Group (http://www.modelobjects.com)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The name "ModelObjects" must not be used to endorse or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact djacobs@modelobjects.com.
 *
 * 5. Products derived from this software may not be called "ModelObjects",
 *    nor may "ModelObjects" appear in their name, without prior written
 *    permission of the ModelObjects Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE MODEL OBJECTS GROUP OR ITS
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ========================================================================
 */

package modelobjects.util;

import java.io.PrintStream;
import java.io.PrintWriter;


/**
 *  WrapperRuntimeException is used in cases where a module wishes to
 *  handle exceptions from another module used in the implementation,
 *  and rethrow as a kind of RuntimeException without losing any of the
 *  context of the original exception.
 */
public class WrapperRuntimeException extends RuntimeException
{
  /**
   * Construct a WrapperRuntimeException using the specfied message.
   */
  public WrapperRuntimeException(String message)
  {
    this(message, null);
  }


  /**
   *  Construct a WrapperRuntimeException from the specified nested exception.
   */
  public WrapperRuntimeException(Throwable nestedException)
  {
    this(null, nestedException);
  }

  /**
   *  Construct a WrapperRuntimeException using the specfied message
   *  and throwable.
   */
  public WrapperRuntimeException(String message, Throwable nestedException)
  {
    super();
    this.nestedException = nestedException;
    this.message = message;
  }

  /**
   *  Return the nested exception.
   */
  public Throwable getNestedException()
  {
    return(nestedException);
  }

  /**
   *  Return the exception message, which is based on that of the nested
   *  exception.
   */
  @Override
public String getMessage()
  {
    if (message != null)
    {
        return(message);
    }
    else if (nestedException != null)
    {
        return(nestedException.getMessage());
    }
    else
    {
        return(super.getMessage());
    }
  }

  /**
   *  Return the localized message, which is based on that of the nested
   *  exception.
   */
  @Override
public String getLocalizedMessage()
  {
    if (message != null)
    {
        return(message);
    }
    else if (nestedException != null)
    {
        return(nestedException.getLocalizedMessage());
    }
    else
    {
        return(super.getLocalizedMessage());
    }
  }

  /**
   *  Return a readable String representation of the WrapperRuntimeException.
   */
  @Override
public String toString()
  {
    StringBuffer buf = new StringBuffer();
    buf.append(getClass().getName());
    buf.append("[");
    buf.append(getMessage());
    buf.append("]");
    return(buf.toString());
  }

  /**
   *  Print the stack-trace from the exception, based on that of the nested
   *  exception.
   */
  @Override
public void printStackTrace()
  {
    printStackTrace(System.err);
  }

  /**
   *  Print the stack-trace from the exception to the specified PrintStream,
   *  based on that of the nested exception.
   */
  @Override
public void printStackTrace(PrintStream s)
  {
    if (nestedException != null)
    {
        nestedException.printStackTrace(s);
    }
    super.printStackTrace(s);
  }

  /**
   *  Print the stack-trace from the exception to the specified PrintWriter,
   *  based on that of the nested exception.
   */
  @Override
public void printStackTrace(PrintWriter s)
  {
    if (nestedException != null)
    {
        nestedException.printStackTrace(s);
    }
    super.printStackTrace(s);
  }

  private final Throwable nestedException;
  private final String    message;
}
