package modelobjects.util.swing;

import java.io.Serializable;
import java.util.EventObject;

import javax.swing.CellEditor;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;

public abstract class AbstractCellEditor
  implements CellEditor, Serializable
{
  protected EventListenerList listenerList = new EventListenerList();
  transient protected ChangeEvent changeEvent = null;

  @Override
public boolean isCellEditable(EventObject e) { 
    return true; 
  } 
  @Override
public boolean shouldSelectCell(EventObject anEvent) { 
    return true; 
  }
  @Override
public boolean stopCellEditing() { 
    fireEditingStopped(); 
    return true;
  }
  @Override
public void  cancelCellEditing() { 
    fireEditingCanceled(); 
  }
  @Override
public void addCellEditorListener(CellEditorListener l) {
    listenerList.add(CellEditorListener.class, l);
  }
  @Override
public void removeCellEditorListener(CellEditorListener l) {
    listenerList.remove(CellEditorListener.class, l);
  }
  protected void fireEditingStopped() {
    Object[] listeners = listenerList.getListenerList();
    for (int i = listeners.length-2; i>=0; i-=2) {
      if (listeners[i]==CellEditorListener.class) {
        if (changeEvent == null)
        {
            changeEvent = new ChangeEvent(this);
        }
        ((CellEditorListener)listeners[i+1]).editingStopped(changeEvent);
      }	       
    }
  }
  protected void fireEditingCanceled() {
    Object[] listeners = listenerList.getListenerList();
    for (int i = listeners.length-2; i>=0; i-=2) {
      if (listeners[i]==CellEditorListener.class) {
        if (changeEvent == null)
        {
            changeEvent = new ChangeEvent(this);
        }
        ((CellEditorListener)listeners[i+1]).editingCanceled(changeEvent);
      }	       
    }
  }
}
