/* ========================================================================
 *
 * The ModelObjects Group Software License, Version 1.0
 *
 *
 * Copyright (c) 2000-2001 ModelObjects Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        ModelObjects Group (http://www.modelobjects.com)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The name "ModelObjects" must not be used to endorse or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact djacobs@modelobjects.com.
 *
 * 5. Products derived from this software may not be called "ModelObjects",
 *    nor may "ModelObjects" appear in their name, without prior written
 *    permission of the ModelObjects Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE MODEL OBJECTS GROUP OR ITS
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ========================================================================
 */

package modelobjects.util.swing;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import modelobjects.util.FindClass;

/**
 *  BeanPropertyTableColumnAdapter is a subclass of TableColumnAdapter
 *  that uses the read-method and write-method of a JavaBeans property
 *  to get and set column values.
 */
public class BeanPropertyTableColumnAdapter extends TableColumnAdapter
{
  public BeanPropertyTableColumnAdapter(PropertyDescriptor propDesc,
                                        int minimumWidth,
                                        int preferredWidth,
                                        int maximumWidth)
  {
    this(propDesc, false, minimumWidth, preferredWidth, maximumWidth);
  }

  public BeanPropertyTableColumnAdapter(PropertyDescriptor propDesc,
                                        boolean includeTypeInColumnLabel,
                                        int minimumWidth,
                                        int preferredWidth,
                                        int maximumWidth)
  {
    super(makeHeaderLabelString(propDesc, includeTypeInColumnLabel),
          propDesc.getWriteMethod() != null,
          getColumnType(propDesc.getPropertyType()),
          minimumWidth, preferredWidth, maximumWidth);

    readMethod  = propDesc.getReadMethod();
    writeMethod = propDesc.getWriteMethod();
  }

  private static String makeHeaderLabelString(PropertyDescriptor propDesc,
                                              boolean includeType)
  {
    if (includeType)
    {
        return("<html><font face=SansSerif size=2><center>" +
                 capitalize(propDesc.getName()) +
                 "<br><font size=1>" +
                 "(" + FindClass.getName(propDesc.getPropertyType(), true) + ")");
    }
    else
    {
        return(capitalize(propDesc.getName()));
    }
  }

  @Override
public Object getColumnValue(Object rowModel, int rowNumber)
  {
    try {
      Object v = readMethod.invoke(rowModel, null);
      if ((v == null) || (v instanceof Number) || (v instanceof Boolean))
    {
        return(v);
    }
    else
    {
        return(v.toString());
    }
    }
    catch (InvocationTargetException e) {
      System.out.println(e.getTargetException());
    }
    catch (Exception e) {
      System.out.println(e);
    }
    return(null);
  }

  @Override
public void setColumnValue(Object rowModel, Object columnValue)
  {
    try {
      writeMethod.invoke(rowModel, new Object[] { columnValue });
    }
    catch (InvocationTargetException e) {
      System.out.println(e.getTargetException());
    }
    catch (Exception e) {
      System.out.println(e);
    }
  }

  public static String capitalize(String name)
  {
    if ((name == null) || (name.length() == 0) ||
        !Character.isLowerCase(name.charAt(0)))
    {
        return(name);
    }
    else
    {
        return(Character.toUpperCase(name.charAt(0)) + name.substring(1));
    }
  }

  private static Class getColumnType(Class propType)
  {
    if (propType.isPrimitive()) {
      if (propType == boolean.class)
    {
        return(Boolean.class);
    }
      if (propType == byte.class)
    {
        return(Byte.class);
    }
      if (propType == char.class)
    {
        return(Character.class);
    }
      if (propType == short.class)
    {
        return(Short.class);
    }
      if (propType == int.class)
    {
        return(Integer.class);
    }
      if (propType == long.class)
    {
        return(Long.class);
    }
      if (propType == float.class)
    {
        return(Float.class);
    }
      if (propType == double.class)
    {
        return(Double.class);
    }
    }
    else if (Number.class.isAssignableFrom(propType)) {
      return(propType);
    }
    return(String.class);
  }

  private Method readMethod;
  private Method writeMethod;
}
