/* ========================================================================
 *
 * The ModelObjects Group Software License, Version 1.0
 *
 *
 * Copyright (c) 2000-2001 ModelObjects Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        ModelObjects Group (http://www.modelobjects.com)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The name "ModelObjects" must not be used to endorse or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact djacobs@modelobjects.com.
 *
 * 5. Products derived from this software may not be called "ModelObjects",
 *    nor may "ModelObjects" appear in their name, without prior written
 *    permission of the ModelObjects Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE MODEL OBJECTS GROUP OR ITS
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ========================================================================
 */

package modelobjects.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

import javax.swing.Icon;

public class ColorIcon implements Icon, java.io.Serializable
{
  public ColorIcon()
  {
    this(Color.white, false);
  }

  public ColorIcon(Color color)
  {
    this(color, false);
  }

  public ColorIcon(Color color, boolean large)
  {
    this.color = color;
    this.large = large;
  }

  @Override
public int getIconHeight()
  {
    return(16);
  }

  @Override
public int getIconWidth()
  {
    return(16);
  }

  public Color getColor()
  {
    return(color);
  }

  public void setColor(Color color)
  {
    this.color = color;
  }

  public Color getBorderColor()
  {
    return(borderColor);
  }

  public void setBorderColor(Color borderColor)
  {
    this.borderColor = borderColor;
  }

  public char getLabelChar()
  {
    return((labelString == null) ? '\000' : labelString.charAt(0));
  }

  public void setLabelChar(char labelChar)
  {
    if (labelChar == '\000')
    {
        labelString = null;
    }
    else
    {
        labelString = new String(new char[] { labelChar });
    }
  }

  @Override
public void paintIcon(Component c, Graphics g, int x, int y)
  {
    if (large) {
      g.setColor(color);
      g.fillRect(x+1, y+1, 12, 12);
      g.setColor(borderColor);
      g.drawRect(x+1, y+1, 12, 12);

      if (labelString != null) {
        g.setColor(getLabelColor());
        g.setFont(c.getFont());
        g.drawString(labelString, x+3, y+12);
      }
    }
    else {
      g.setColor(color);
      g.fillRect(x+3, y+3, 8, 8);
      g.setColor(borderColor);
      g.drawRect(x+3, y+3, 8, 8);
    }
  }

  private Color getLabelColor()
  {
    Color c = color;
    int r = c.getRed();
    int b = c.getBlue();
    int g = c.getGreen();

    return(((r+b+g) < 200) ? Color.white : Color.black);
  }

  private boolean large;
  private Color   color;
  private Color   borderColor = Color.black;
  private String  labelString;
}
