package modelobjects.util.swing;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class DynamicTreeNodeTest extends JFrame
  implements ActionListener, TreeSelectionListener
{
  public DynamicTreeNodeTest(File rootDir)
  {
    super("DynamicTreeNode Test");
    setProperties();
    
    if (false) {
      try {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName()); }
      catch (Exception tooBad) { }
    }

    table = new DirectoryFileTable();
    table.setRowHeight(table.getRowHeight() + 3);       // looks nicer

    rootNode = new DirectoryFileTreeNode(rootDir, true);
    tree = new JTree(rootNode);
    tree.getSelectionModel().setSelectionMode
      (TreeSelectionModel.SINGLE_TREE_SELECTION);
    tree.setShowsRootHandles(false);                    // false is the default

    tree.setCellRenderer(new DynamicTreeCellRenderer());
    tree.addTreeSelectionListener(this);

    addContentPaneProperties();
  }

  private void setProperties() {
      setDefaultCloseOperation(EXIT_ON_CLOSE);
      setBounds(200, 200, 800, 500);
  }
  
  private void addContentPaneProperties() {

      JPanel buttonPanel = new JPanel();
      buttonPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
      refreshButton = new JButton("Refresh");
      buttonPanel.add(refreshButton);
      refreshButton.addActionListener(this);

      JScrollPane treeScroller = new JScrollPane(tree);
      JScrollPane tableScroller = new JScrollPane(table);
      treeScroller.getViewport().setBackground(tree.getBackground());
      tableScroller.getViewport().setBackground(table.getBackground());

      JSplitPane splitPane =
      new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, treeScroller, tableScroller);
      splitPane.setDividerLocation(200);

      getContentPane().add(buttonPanel, BorderLayout.NORTH);
      getContentPane().add(splitPane, BorderLayout.CENTER);
  }

  /**
   *  Handle the refresh button.
   */
  @Override
public void actionPerformed(ActionEvent e)
  {
    if (e.getSource() == refreshButton) {
      rootNode.refresh(tree, (DefaultTreeModel)tree.getModel());
    }
  }

  /**
   *  Handle a selection change in the tree.
   */
  @Override
public void valueChanged(TreeSelectionEvent e)
  {
    // get the directory from the tree and set it in the table
    
    TreePath selection = tree.getSelectionPath();
    if (selection == null)
    {
        table.setDirectory(null);
    }
    else {
      DirectoryFileTreeNode dirNode =
        (DirectoryFileTreeNode)selection.getLastPathComponent();

      // if the directory turns out not to have any subdirectories,
      // call expandPath to get rid of the enpansion doohickee
      if (dirNode.getChildCount() == 0)
    {
        tree.expandPath(selection);
    }

      File file = dirNode.getFile();
      table.setDirectory(file.isDirectory() ? file : null);
    }
  }

  public static void main(String[] args)
    throws Exception
  {
    String dirName = ((args.length == 0) ? "." : args[0]);
    DynamicTreeNodeTest test = new DynamicTreeNodeTest(new File(dirName));
    test.setVisible(true);
  }

  DirectoryFileTreeNode rootNode;
  JTree                 tree;
  DirectoryFileTable    table;
  JButton               refreshButton;
}
