/* ========================================================================
 *
 * The ModelObjects Group Software License, Version 1.0
 *
 *
 * Copyright (c) 2000-2001 ModelObjects Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product include software developed by the
 *        ModelObjects Group (http://www.modelobjects.com)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The name "ModelObjects" must not be used to endorse or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact djacobs@modelobjects.com.
 *
 * 5. Products derived from this software may not be called "ModelObjects",
 *    nor may "ModelObjects" appear in their name, without prior written
 *    permission of the ModelObjects Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE MODEL OBJECTS GROUP OR ITS
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ========================================================================
 */

package modelobjects.util.swing;

import java.util.Comparator;
import java.util.List;

import javax.swing.table.TableModel;


public interface IModelTableModel extends TableModel
{
    /**
     * Return the contents of the model as a java.util.List.
     */
    public List getContents();

    /**
     * Assign the model List contents of this ModelListTableModel.
     */
    public void setContents(List contents);

    /**
     * Return this ModelListTableModel's array of TableColumnAdapters.
     */
    public TableColumnAdapter[] getColumnAdapters();

    /**
     * Return the TableColumnAdapter for the specified model column index.
     */
    public TableColumnAdapter getColumnAdapter(int modelColumnIndex);

    /**
     * Return the row model object at the specified index of this
     * ModelListTableModel.
     */
    public Object getRowModel(int row);

    public int findCell(int startRow, int columnIndex, Object value);

    /**
     * Return the index of the specified object in the contents List if it
     * is present, or the index at which to insert the object otherwise,
     * encoded as (-1 - insertionIndex).
     * If the contents are sorted, a binary search is used.  Otherwise a
     * linear search is used and if the object is not present the insertion
     * index is at the end of the list.
     */
    public int getIndexOf(Object obj);

    /**
     * Insert the specified row model object into this ModelListTableModel
     * at the specified row index.
     */
    public void insertRow(Object rowModel, int index);

    /**
     * Insert the specified row model object into this ModelListTableModel
     * maintaining sorted order if the model is currently sorted, or at the
     * end otherwise.  It is illegal to insert a row model object that is
     * already present.
     */
    public void insertRowMaintainSort(Object rowModel);

    /**
     * Delete the row at the specified index.
     */
    public void deleteRow(int index);

    /**
     * Delete the specified object from this ModelListTableModel if it is present.
     */
    public void delete(Object obj);

    /**
     * Clear the contents of the model.
     */
    public void clear();

    /**
     * Notify TableModelListeners that the specified row has changed.
     */
    public void rowChanged(int index);

    //-------------------------------------------------------------------------
    //
    // Sorting Support
    //
    //-------------------------------------------------------------------------

    /**
     * Sort this ModelListTableModel by the specified model column.  If the
     * table is not currently sorted by that column, the column's normal
     * Comparator is used to perform the sort.  Otherwise, the column's
     * reverse comparator is used.
     */
    public void sortByColumn(int modelColumnIndex);

    /**
     * Sort this ModelListTableModel by the specified model column, specifying
     * whether to sort in ascending or descending order.
     *
     * The ModelListTableModel is sorted by extracting the complete contents
     * List into an object array, sorting the array using the Comparator,
     * and then replacing the contents of the list with the sorted array.
     */
    public void sortByColumn(int modelColumnIndex, boolean ascending);

    /**
     * Assert that the table is sorted by the specified column's Comparator,
     * and indicate whether it's sorted ascending or not.  If the sortColumn
     * and/or sortComparator are changed by this method, PropertyChangeEvents
     * are fired to notify listeners about the changes.
     */
    public void setSortedByColumn(int modelColumnIndex, boolean ascending);

    /**
     * Return the comparator by which the table is sorted, or null if it's
     * not currently sorted.
     */
    public Comparator getSortComparator();

    /**
     * Return whether this ModelListTableModel is current sorted.
     */
    public boolean isSorted();

    /**
     * Return the model column by which the table is sorted, or -1 if it's
     * not currently sorted.
     */
    public int getSortColumn();

    /**
     * Return whether this ModelListTableModel is sorted in ascending order.
     * The results of this method are meaningless if it is not sorted at all.
     */
    public boolean isSortedInAscendingOrder();
}
