/* ========================================================================
 *
 * The ModelObjects Group Software License, Version 1.0
 *
 *
 * Copyright (c) 2000-2001 ModelObjects Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        ModelObjects Group (http://www.modelobjects.com)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The name "ModelObjects" must not be used to endorse or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact djacobs@modelobjects.com.
 *
 * 5. Products derived from this software may not be called "ModelObjects",
 *    nor may "ModelObjects" appear in their name, without prior written
 *    permission of the ModelObjects Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE MODEL OBJECTS GROUP OR ITS
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ========================================================================
 */

package modelobjects.util.swing;

import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

/**
 *  ModelPropertyTableColumn is a subclass of javax.swing.table.TableColumn
 *  that's based on a TableColumnAdapter.
 */
public class ModelPropertyTableColumn extends TableColumn
{
  ModelPropertyTableColumn(int modelIndex, TableColumnAdapter tca)
  {
    super(modelIndex, tca.getPreferredWidth());

    this.tableColumnAdapter = tca;
    setProperties(tca);
  }
  
  private void setProperties(TableColumnAdapter tca) {
      
    setHeaderValue(tca.getHeaderLabel());
    setPreferredWidth(tca.getPreferredWidth());
    setMinWidth(tca.getMinimumWidth());
    setMaxWidth(tca.getMaximumWidth());
    setResizable(minWidth < maxWidth);
  }

  public TableColumnAdapter getTableColumnAdapter()
  {
    return(tableColumnAdapter);
  }

  @Override
public TableCellRenderer getCellRenderer()
  {
    return(tableColumnAdapter.getCellRenderer());
  }
    
  @Override
public void setCellRenderer(TableCellRenderer renderer)
  {
    super.setCellRenderer(renderer);
    tableColumnAdapter.setCellRenderer(renderer);
  }

  @Override
public TableCellEditor getCellEditor()
  {
    return(tableColumnAdapter.getCellEditor());
  }

  @Override
public void setCellEditor(TableCellEditor editor)
  {
    super.setCellEditor(editor);
    tableColumnAdapter.setCellEditor(editor);
  }

  public Class getColumnClass()
  {
    return(tableColumnAdapter.getColumnClass());
  }

  @Override
public String toString()
  {
    return("TableColumn[" + tableColumnAdapter + "]");
  }

  private TableColumnAdapter tableColumnAdapter;
}
