/* ========================================================================
 *
 * The ModelObjects Group Software License, Version 1.0
 *
 *
 * Copyright (c) 2000-2001 ModelObjects Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        ModelObjects Group (http://www.modelobjects.com)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The name "ModelObjects" must not be used to endorse or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact djacobs@modelobjects.com.
 *
 * 5. Products derived from this software may not be called "ModelObjects",
 *    nor may "ModelObjects" appear in their name, without prior written
 *    permission of the ModelObjects Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE MODEL OBJECTS GROUP OR ITS
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ========================================================================
 */

package modelobjects.util.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EventObject;

import javax.accessibility.AccessibleContext;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class NorthGravityCellEditor extends AbstractCellEditor
  implements TableCellEditor
{
  public NorthGravityCellEditor(TableCellEditor innerCellEditor)
  {
    this.innerCellEditor = innerCellEditor;
    this.panel = new WrapperPanel();
    panel.setOpaque(true);
    panel.setLayout(new BorderLayout());
  }

  @Override
public Object getCellEditorValue()
  {
    return(innerCellEditor.getCellEditorValue());
  }

  @Override
public boolean isCellEditable(EventObject anEvent) {
    return(innerCellEditor.isCellEditable(anEvent));
  }

  @Override
public void cancelCellEditing()
  {
    innerCellEditor.cancelCellEditing();
    super.cancelCellEditing();
  }

  @Override
public boolean stopCellEditing()
  {
    return(innerCellEditor.stopCellEditing() && super.stopCellEditing());
  }

  @Override
public Component getTableCellEditorComponent
    (JTable table, Object value, boolean isSelected, int row, int column)
  {
    final Component comp =
      innerCellEditor.getTableCellEditorComponent(table, value, isSelected,
                                                  row, column);
    if (panel.getComponentCount() == 0) {
      panel.add(comp, BorderLayout.NORTH);
    }
    else if (panel.getComponent(0) != comp) {
      panel.remove(0);
      panel.add(comp, BorderLayout.NORTH);
    }

    // blend in when some of panel is exposed
    panel.setBackground(table.getSelectionBackground());

    SwingUtilities.invokeLater(new Runnable() {
      @Override
    public void run() {
        comp.requestFocus();
      }
    });

    return(panel);
  }

  private static class WrapperPanel extends JPanel
  {
    @Override
    public AccessibleContext getAccessibleContext() {
      if (getComponentCount() > 0) {
        Component sub = getComponent(0);
        return(sub.getAccessibleContext());
      }
      else {
        return(super.getAccessibleContext());
      }
    }
  }

  private TableCellEditor       innerCellEditor;
  private JPanel                panel;

}
