/* ========================================================================
 *
 * The ModelObjects Group Software License, Version 1.0
 *
 *
 * Copyright (c) 2000-2001 ModelObjects Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        ModelObjects Group (http://www.modelobjects.com)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The name "ModelObjects" must not be used to endorse or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact djacobs@modelobjects.com.
 *
 * 5. Products derived from this software may not be called "ModelObjects",
 *    nor may "ModelObjects" appear in their name, without prior written
 *    permission of the ModelObjects Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE MODEL OBJECTS GROUP OR ITS
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ========================================================================
 */
package modelobjects.util.undo;

import javax.swing.undo.AbstractUndoableEdit;

/**
 *  This is a common base class for simple UndoableEdits used by the
 *  ModelObjects framework.  It provides common behavior for handling
 *  presentation names and for handling basic undo and redo state errors.
 */
public abstract class PresentableUndoableEdit extends AbstractUndoableEdit
{
  protected PresentableUndoableEdit(String presentationName)
  {
    this.presentationName = presentationName;
  }

  /**
   *  Undo the UndoableEdit.  Subclasses should add the rest of their
   *  undo behavior after calling super.undo().
   *  @throws CannotUndoException if the canUndo() returns false
   */
  @Override
public void undo()
    throws CannotUndoException
  {
    if (!canUndo())
      {
        Exception reason = new IllegalStateException("canUndo == false");
        throw(new CannotUndoException(getUndoPresentationName(), reason));
      }
    super.undo();
  }

  /**
   *  Redo the UndoableEdit.  Subclasses should add the rest of their
   *  redo behavior after calling super.redo().
   *  @throws CannotUndoException if the canRedo() returns false
   */
  @Override
public void redo()
    throws CannotRedoException
  {
    if (!canRedo())
      {
        Exception reason = new IllegalStateException("canRedo == false");
        throw(new CannotRedoException(getRedoPresentationName(), reason));
      }
    super.redo();
  }

  /**
   *  Return the presentation name
   */
  @Override
public String getPresentationName()
  {
    return(presentationName);
  }

  /**
   *  Return the undo presentation name
   */
  @Override
public String getUndoPresentationName()
  {
    return("undo " + presentationName);
  }

  /**
   *  Return the redo presentation name
   */
  @Override
public String getRedoPresentationName()
  {
    return("redo " + presentationName);
  }

  private String presentationName;
}
