/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.progress.sonic.esb.camel.AsyncResponseHandler;
import com.progress.sonic.esb.camel.DefaultAsyncResponseHandler;
import com.progress.sonic.esb.camel.EsbMessageExchange;
import com.progress.sonic.esb.camel.ProcessAddressFactory;
import com.progress.sonic.esb.camel.SonicEsbEndpoint;
import com.progress.sonic.esb.camel.SonicEsbURI;
import com.progress.sonic.esb.camel.util.EsbUtils;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQDispatch;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQProcessAddress;
import com.sonicsw.xq.XQProcessContext;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xq.service.asynch.AXQMessageHandler;
import com.sonicsw.xq.service.asynch.IAXQMessageHandler;
import com.sonicsw.xqimpl.envelope.XQProcessAddressImpl;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.Iterator;
import java.util.Properties;
import org.apache.camel.Exchange;

public class DefaultEsbMessageExchange
implements EsbMessageExchange {
    private XQLog log = XQLogImpl.getInstance();
    private AsyncResponseHandler asyncResponseHandler;
    private ProcessAddressFactory processAddressFactory;

    public DefaultEsbMessageExchange(AsyncResponseHandler asyncResponseHandler, ProcessAddressFactory processAddressFactory) {
        this.asyncResponseHandler = asyncResponseHandler;
        this.processAddressFactory = processAddressFactory;
        assert (asyncResponseHandler instanceof DefaultAsyncResponseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XQMessage[] send(Exchange exchange, XQMessage inputMsg, SonicEsbEndpoint esbEndpoint) throws Exception {
        String correlationId = null;
        DefaultAsyncResponseHandler defaultAsyncHandler = null;
        AXQMessageHandler asyncMessageHandler = null;
        try {
            XQInitContext xqInitContext = esbEndpoint.getXQInitContext();
            XQServiceContext xqServiceContext = (XQServiceContext)exchange.getProperty(XQServiceContext.class.getName(), XQServiceContext.class);
            if (xqServiceContext != null) {
                xqInitContext = xqServiceContext;
            }
            SonicEsbURI sonicURI = (SonicEsbURI)exchange.getProperty("sonicesb-uri-object");
            defaultAsyncHandler = (DefaultAsyncResponseHandler)this.asyncResponseHandler;
            asyncMessageHandler = new AXQMessageHandler();
            correlationId = defaultAsyncHandler.createUniqueCorrelationID();
            defaultAsyncHandler.registerMessageHandler(correlationId, (IAXQMessageHandler)asyncMessageHandler);
            asyncMessageHandler.setMessageCount(1);
            XQAddress xqAddress = sonicURI.getXQAddress();
            XQAddress savedReplyTo = inputMsg.getReplyTo();
            String savedJMSCorrelationId = inputMsg.getCorrelationId();
            this.dispatchMessage(exchange, inputMsg, xqInitContext, xqAddress, esbEndpoint.getEsbConfig().getQualityOfService(), correlationId, defaultAsyncHandler);
            asyncMessageHandler.waitForComplete(esbEndpoint.getEsbConfig().getTimeoutInterval());
            short status = defaultAsyncHandler.getResultStatus((IAXQMessageHandler)asyncMessageHandler);
            if (status == -1) {
                throw new XQServiceException("Request to: " + xqAddress + " timed out");
            }
            XQMessage[] resultMessages = asyncMessageHandler.getResult();
            for (int i = 0; i < resultMessages.length; ++i) {
                resultMessages[i].setReplyTo(savedReplyTo);
                resultMessages[i].setCorrelationId(savedJMSCorrelationId);
            }
            XQMessage[] xQMessageArray = resultMessages;
            if (defaultAsyncHandler != null && correlationId != null) {
                defaultAsyncHandler.unRegisterMessageHandler(correlationId);
            }
            return xQMessageArray;
        }
        catch (Throwable throwable) {
            if (defaultAsyncHandler != null && correlationId != null) {
                defaultAsyncHandler.unRegisterMessageHandler(correlationId);
            }
            throw throwable;
        }
    }

    private void dispatchMessage(Exchange exchange, XQMessage inputMsg, XQInitContext xqInitContext, XQAddress esbDestination, XQQualityofService qos, String correlationId, DefaultAsyncResponseHandler defaultAsyncHandler) throws Exception {
        XQDispatch dispatcher = xqInitContext.getDispatcher();
        XQAddress tmpEPAddress = defaultAsyncHandler.getTempAddress();
        inputMsg.setReplyTo(tmpEPAddress);
        inputMsg.setCorrelationId(correlationId);
        inputMsg.setStringHeader("asyncReplyForDestinaton", esbDestination.toString());
        XQProcessAddressImpl processAddress = this.processAddressFactory.create(esbDestination);
        if (processAddress != null) {
            processAddress.removeAllExitEndpoints();
            processAddress.addExitEndpoint(tmpEPAddress);
            if (this.log.isDebugLoggingEnabled()) {
                this.log.logDebug("[" + this.asyncResponseHandler.getServiceName() + "] ExitEndpoints: ");
                Iterator iter = processAddress.getExitEndpoints();
                while (iter.hasNext()) {
                    this.log.logDebug("[" + this.asyncResponseHandler.getServiceName() + "] " + iter.next());
                }
            }
            if (xqInitContext instanceof XQServiceContext) {
                if (this.log.isDebugLoggingEnabled()) {
                    this.log.logDebug("[" + this.asyncResponseHandler.getServiceName() + "] overrideFromProcessContext");
                }
                processAddress.overrideFromProcessContext(((XQServiceContext)xqInitContext).getProcessContext());
            } else {
                processAddress.setRMEAddress(tmpEPAddress);
                processAddress.setFaultAddress(tmpEPAddress);
                processAddress.setQualityOfService(qos);
            }
            this.populateInflightProperties((XQProcessAddress)processAddress, exchange);
            if (this.log.isDebugLoggingEnabled()) {
                this.log.logDebug("[" + this.asyncResponseHandler.getServiceName() + "] RMEAddress: " + processAddress.getRMEAddress() + " FaultAddress: " + processAddress.getFaultAddress() + " QualityOfService: " + processAddress.getQualityofService());
            }
            XQEnvelope newEnv = xqInitContext.getEnvelopeFactory().createTargetedEnvelope((XQAddress)processAddress, inputMsg);
            if (this.log.isDebugLoggingEnabled()) {
                this.log.logDebug("[" + this.asyncResponseHandler.getServiceName() + "] Dispatching to: " + esbDestination.getName() + " with corrID: " + inputMsg.getCorrelationId());
            }
            dispatcher.dispatch(newEnv, qos);
        }
    }

    private void populateInflightProperties(XQProcessAddress processAddress, Exchange exchange) {
        Properties properties;
        XQProcessContext procCtx = EsbUtils.getProcessContext(exchange, null, false);
        if (procCtx != null && (properties = procCtx.getInflightProperties()) != null) {
            processAddress.setInflightProperties(properties);
        }
    }
}

