/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.progress.sonic.esb.camel.EsbMessageExchange;
import com.progress.sonic.esb.camel.SonicEsbEndpoint;
import com.progress.sonic.esb.camel.SonicEsbURI;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQDispatch;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQServiceContext;
import org.apache.camel.Exchange;

public class OnewayEsbMessageExchange
implements EsbMessageExchange {
    @Override
    public XQMessage[] send(Exchange exchange, XQMessage inputMsg, SonicEsbEndpoint esbEndpoint) throws Exception {
        SonicEsbURI sonicURI = (SonicEsbURI)exchange.getProperty("sonicesb-uri-object");
        XQAddress destinationAddress = sonicURI.getXQAddress();
        XQInitContext xqInitContext = esbEndpoint.getXQInitContext();
        XQServiceContext xqServiceContext = (XQServiceContext)exchange.getProperty(XQServiceContext.class.getName(), XQServiceContext.class);
        if (xqServiceContext != null) {
            xqInitContext = xqServiceContext;
        }
        XQEnvelope envelope = xqInitContext.getEnvelopeFactory().createTargetedEnvelope(destinationAddress, inputMsg);
        XQDispatch dispatcher = xqInitContext.getDispatcher();
        dispatcher.dispatch(envelope, esbEndpoint.getEsbConfig().getQualityOfService());
        return new XQMessage[0];
    }
}

