/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.progress.sonic.esb.camel.AbstractRuleBasedBindingStrategy;
import com.progress.sonic.esb.camel.AttachmentReferencesDetection;
import com.progress.sonic.esb.camel.util.AttachmentUtils;
import com.progress.sonic.esb.camel.util.EsbUtils;
import com.progress.sonic.esb.camel.util.Range;
import com.progress.sonic.esb.camel.util.RestAttachmentUtils;
import com.progress.sonic.esb.camel.util.URLTemplateUtils;
import com.sonicsw.esb.process.mapping.InvocationContext;
import com.sonicsw.esb.process.mapping.ParameterValue;
import com.sonicsw.esb.process.mapping.ParameterValueMap;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQException;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.XQServiceContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.MimeType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;

public class RestBindingStrategy
extends AbstractRuleBasedBindingStrategy {
    private static List<Range> serrorStatusRangesList = new ArrayList<Range>();
    private List<Range> errorStatusRangesList = serrorStatusRangesList;
    private boolean shouldReadAsOctets = false;

    public boolean isShouldReadAsOctets() {
        return this.shouldReadAsOctets;
    }

    public void setShouldReadAsOctets(boolean shouldReadAsOctets) {
        this.shouldReadAsOctets = shouldReadAsOctets;
    }

    public List<Range> getErrorStatusRangesList() {
        return this.errorStatusRangesList;
    }

    public void setErrorStatusRangesList(List<Range> errorStatusRangesList) {
        this.errorStatusRangesList = errorStatusRangesList;
    }

    @Override
    public Object bindRequestBodyFromXQMessage(XQMessage xqMessage, Exchange exchange) throws Exception {
        Object result = EsbUtils.getInputFromParamMapOrMsgBodyPart(exchange, xqMessage, "PostData");
        Map<String, DataHandler> attachments = super.bindRequestAttachmentsFromXQMessage(xqMessage, exchange);
        if (attachments == null || attachments.size() == 0) {
            return result == null ? "" : result;
        }
        ArrayList<Attachment> list = new ArrayList<Attachment>();
        String contentType = (String)EsbUtils.getInputFromParamMapOrMsgBodyPart(exchange, xqMessage, "ContentType");
        String rootContentId = this.getRootContentId(contentType);
        boolean rootPartAdded = false;
        if (rootContentId != null) {
            if (result != null) {
                list.add(new Attachment(rootContentId, contentType, result));
                rootPartAdded = true;
            } else {
                DataHandler dh = attachments.get(rootContentId);
                if (dh != null) {
                    MetadataMap headers = new MetadataMap();
                    headers.putSingle((Object)"Content-Type", (Object)dh.getContentType());
                    list.add(new Attachment(rootContentId, dh, (MultivaluedMap)headers));
                    rootPartAdded = true;
                }
            }
        }
        for (Map.Entry<String, DataHandler> entry : attachments.entrySet()) {
            if (rootPartAdded && entry.getKey().equalsIgnoreCase(rootContentId)) continue;
            DataHandler dh = entry.getValue();
            MetadataMap headers = new MetadataMap();
            headers.putSingle((Object)"Content-Type", (Object)dh.getContentType());
            list.add(new Attachment(entry.getKey(), dh, (MultivaluedMap)headers));
        }
        return new MultipartBody(list);
    }

    private String getRootContentId(String contentType) {
        if (contentType == null) {
            return null;
        }
        MimeType mimeType = null;
        try {
            mimeType = new MimeType(contentType);
        }
        catch (Exception e) {
            return null;
        }
        String rootContentType = mimeType.getParameter("type");
        if (rootContentType == null) {
            return null;
        }
        String rootContentId = mimeType.getParameter("start");
        if (rootContentId == null) {
            rootContentId = "root.message@cxf.apache.org";
        } else if (rootContentId.charAt(0) == '<' && rootContentId.charAt(rootContentId.length() - 1) == '>') {
            rootContentId = rootContentId.substring(1, rootContentId.length() - 1);
        }
        return rootContentId;
    }

    @Override
    protected Map<String, DataHandler> scanAttachments(AttachmentReferencesDetection scanAction, Exchange exchange, XQMessage xqMessage, boolean isRequest) throws Exception {
        if (AttachmentReferencesDetection.SCAN_MESSAGE_PARTS == scanAction) {
            return this.scanAttachmentFromXQMessage(exchange, xqMessage, isRequest);
        }
        return new HashMap<String, DataHandler>();
    }

    private Map<String, DataHandler> scanAttachmentFromXQMessage(Exchange exchange, XQMessage xqMessage, boolean isRequest) throws Exception {
        Object result = null;
        String contentType = null;
        Element doc = null;
        LinkedHashMap<String, DataHandler> answer = new LinkedHashMap<String, DataHandler>();
        if (isRequest) {
            contentType = (String)EsbUtils.getInputFromParamMapOrMsgBodyPart(exchange, xqMessage, "ContentType");
            if (contentType == null || !contentType.startsWith("multipart")) {
                return answer;
            }
            result = EsbUtils.getInputFromParamMapOrMsgBodyPart(exchange, xqMessage, "PostData");
        } else if (xqMessage.doesPartExist("Response")) {
            XQPart part = xqMessage.getPart("Response");
            contentType = part.getContentType();
            if (contentType == null || !contentType.startsWith("multipart")) {
                return answer;
            }
            result = part.getContent();
        }
        if (!(result instanceof String)) {
            return answer;
        }
        try {
            doc = StaxUtils.read((Reader)new StringReader((String)result)).getDocumentElement();
            String docNs = doc.getNamespaceURI();
            if (docNs == null || !"http://www.progress.com/sonic/esb/service/connect/attachmentspec".equals(docNs)) {
                return answer;
            }
        }
        catch (Exception e) {
            return answer;
        }
        this.collectRestAttachments(answer, exchange, xqMessage, doc);
        if (answer.size() > 0) {
            if (isRequest) {
                exchange.getIn().setBody(null);
            } else {
                exchange.getOut().setBody(null);
            }
        }
        return answer;
    }

    protected void collectRestAttachments(Map<String, DataHandler> answer, Exchange exchange, XQMessage xqMessage, Element referringSpec) throws Exception {
        Collection<RestAttachmentUtils.AttachmentSpec> specs = null;
        try {
            specs = RestAttachmentUtils.getAttachmentSpecifications(referringSpec);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (specs != null) {
            block6: for (RestAttachmentUtils.AttachmentSpec spec : specs) {
                XQPart attachmentPart;
                switch (spec.getSpecType()) {
                    case EXPRESSION: {
                        Object evaluation = EsbUtils.evaluate((String)spec.getValue(), xqMessage, EsbUtils.getServiceContext(exchange));
                        attachmentPart = xqMessage.createPart(evaluation, spec.getContentType());
                        answer.put(spec.getName(), attachmentPart.getDataHandler());
                        continue block6;
                    }
                    case HREF: {
                        AttachmentUtils.applyHRefAttachment(answer, (String)spec.getValue(), xqMessage);
                        continue block6;
                    }
                }
                attachmentPart = xqMessage.createPart(spec.getValue(), spec.getContentType());
                answer.put(spec.getName(), attachmentPart.getDataHandler());
            }
        }
    }

    @Override
    public Map<String, Object> bindRequestHeadersFromXQMessage(XQMessage message, Exchange exchange) throws Exception {
        String contentType;
        String uriTemplate;
        String fullpathandquery = null;
        ParameterValueMap pvm = EsbUtils.getInputParamValueMap(exchange);
        HashMap<String, Object> answer = new HashMap<String, Object>();
        String method = EsbUtils.getStringFromParamMap(pvm, message, "Method");
        ObjectHelper.notNull((Object)method, (String)"Message mapping input parameter 'Method'");
        String accept = EsbUtils.getStringFromParamMap(pvm, message, "Accept");
        if ("GET".equalsIgnoreCase(method)) {
            ObjectHelper.notNull((Object)accept, (String)"Message mapping input parameter 'Accept'");
        }
        if ((uriTemplate = (String)exchange.getProperty("URITemplate")) != null) {
            ArrayList<String> values = new ArrayList<String>();
            URITemplate template = new URITemplate(uriTemplate);
            MetadataMap localValues = new MetadataMap();
            for (String variable : template.getVariables()) {
                boolean templateEscapeRequired;
                String content = EsbUtils.getStringFromParamMap(pvm, message, variable);
                ObjectHelper.notNull((Object)content, (String)("URI Template parameter name = '" + variable + "'"));
                boolean bl = templateEscapeRequired = content != null && content.startsWith("{") && content.endsWith("}");
                if (templateEscapeRequired) {
                    content = "%7B" + content.substring(1, content.length() - 1) + "%7D";
                }
                values.add(content);
                localValues.putSingle((Object)variable, (Object)content);
            }
            exchange.setProperty("URI_TEMPLATE_PARMS", (Object)localValues);
            fullpathandquery = template.substitute(values);
        } else {
            int endOfHost;
            String url;
            fullpathandquery = url = EsbUtils.getStringFromParamMap(pvm, message, "URL");
            int endOfScheme = url.indexOf(":");
            if (endOfScheme != -1 && (endOfHost = url.indexOf(47, endOfScheme + 3)) != -1) {
                fullpathandquery = url.substring(endOfHost);
            }
        }
        Map<String, String> queryMap = URLTemplateUtils.extractQueryMap(fullpathandquery);
        String queryString = URLTemplateUtils.extractQueryString(fullpathandquery);
        answer.put("CamelCxfRsQueryMap", queryMap);
        if (queryString != null && queryString.length() > 0) {
            answer.put("CamelHttpQuery", queryString);
        }
        if ((contentType = EsbUtils.getStringFromParamMap(pvm, message, "ContentType")) == null) {
            contentType = this.deriveRequestContentType(message, method);
        }
        this.setHttpRequestHeaders(answer, method, accept, contentType, fullpathandquery);
        answer.put("CamelCxfRsUsingHttpAPI", true);
        this.applyGeneralBindRequestHeaderRules(answer, message, exchange);
        return answer;
    }

    protected void applyGeneralBindRequestHeaderRules(Map<String, Object> answer, XQMessage message, Exchange exchange) throws Exception {
        answer.putAll(super.bindRequestHeadersFromXQMessage(message, exchange));
    }

    @Override
    public XQMessage bindResponseBodyFromCamelExchange(Exchange exchange) throws Exception {
        XQEnvelope envelope;
        XQMessage out = null;
        ParameterValueMap pvm = null;
        XQServiceContext sc = EsbUtils.getServiceContext(exchange);
        InvocationContext ic = EsbUtils.getInvocationContext(exchange);
        Integer rc = this.extractStatusCode(exchange);
        boolean isFault = this.isErrorStatusCode(rc);
        if (EsbUtils.hasInvocationMapping(ic)) {
            pvm = isFault ? ic.getFaultParameterValues("SonicESB.Rest.Fault") : ic.getOutputParameterValues();
        }
        if (pvm == null) {
            out = (XQMessage)exchange.getOut().getBody(XQMessage.class);
            if (out != null) {
                out.setIntHeader("StatusCode", rc.intValue());
            } else {
                envelope = sc.getFirstIncoming();
                out = envelope.getMessage();
                out.removeAllParts();
                out.setIntHeader("StatusCode", rc.intValue());
                Object result = EsbUtils.extractResultBody(exchange);
                if (result != null) {
                    XQPart part = out.createPart(this.messageResultBody(result, exchange), "text/xml");
                    part.setContentId("Response");
                    out.addPart(part);
                }
                this.appendAttachment(out, result);
            }
        } else {
            envelope = sc.getFirstIncoming();
            out = envelope.getMessage();
            ParameterValue pvStatusCode = pvm.getParameterValue("StatusCode");
            ParameterValue pvResponse = pvm.getParameterValue("Response");
            if (pvStatusCode != null) {
                pvStatusCode.setValue((Object)rc.toString());
            }
            if (isFault) {
                exchange.getOut().getHeaders().putAll(EsbUtils.extractResultHeaders(exchange));
            }
            Object result = EsbUtils.extractResultBody(exchange);
            if (pvResponse != null) {
                pvResponse.setValue(this.messageResultBody(result, exchange));
            }
            this.appendAttachment(out, result);
            if (isFault) {
                out.setStringHeader("SonicESB.Fault.Name", "SonicESB.Rest.Fault");
            }
        }
        if (exchange.hasOut()) {
            for (Map.Entry<String, DataHandler> entry : AttachmentUtils.getAttachments(exchange).entrySet()) {
                this.applyAttachmentToMessage(out, entry.getKey(), entry.getValue());
            }
            this.propagateHeadersFromCamel(exchange.getOut().getHeaders(), exchange, out);
        }
        this.applyBindingRules(exchange, out, exchange.getOut(), false);
        return out;
    }

    private void appendAttachment(XQMessage out, Object result) throws Exception {
        if (result instanceof MultipartBody) {
            List list = ((MultipartBody)result).getAllAttachments();
            for (Attachment attachment : list) {
                this.applyAttachmentToMessage(out, attachment.getContentId(), attachment.getDataHandler());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void bindEsbRequestFromExchange(XQMessage requestMsg, Exchange exchange) throws Exception {
        String accept;
        String string;
        Message request = exchange.getIn();
        String method = (String)request.getHeader("CamelHttpMethod", String.class);
        if (method != null) {
            requestMsg.setStringHeader("Method", method);
        }
        String url = (String)request.getHeader("CamelHttpUrl", String.class);
        String query = (String)request.getHeader("CamelHttpQuery", String.class);
        if (url != null) {
            String furl = url;
            if (query != null && query.length() > 0) {
                furl = url + "?" + query;
            }
            requestMsg.setStringHeader("URL", furl);
        }
        if (!requestMsg.doesPartExist("PostData")) {
            XQPart p = requestMsg.createPart((Object)"", "text/plain");
            p.setContentId("PostData");
            requestMsg.addPart(p);
        }
        for (Map.Entry entry : AttachmentUtils.getAttachments(exchange).entrySet()) {
            this.applyAttachmentToMessage(requestMsg, (String)entry.getKey(), (DataHandler)entry.getValue());
        }
        String base = (String)request.getHeader("CamelHttpBaseUri", String.class);
        if (url != null && base != null) {
            void var8_11;
            int endOfScheme = url.indexOf(":");
            int endOfHost = url.indexOf(47, endOfScheme + 3);
            if (endOfHost == -1) {
                endOfHost = url.indexOf(63, endOfScheme + 3);
            }
            if (endOfHost != -1) {
                String string2 = url.substring(0, endOfHost);
            } else {
                String string3 = url;
            }
            requestMsg.setStringHeader("BaseURL", (String)var8_11 + base);
        }
        if ((string = (String)exchange.getProperty("URITemplate", String.class)) != null) {
            requestMsg.setStringHeader("URITemplate", string);
        }
        if ((accept = (String)request.getHeader("Accept", String.class)) != null) {
            requestMsg.setStringHeader("Accept", accept);
        }
        this.setTemplateHeaderValues(exchange, requestMsg);
        this.applyBindingRules(exchange, requestMsg, exchange.getIn(), true);
        this.propagateHeadersFromCamel(exchange.getIn().getHeaders(), exchange, requestMsg);
    }

    protected Object messageResultBody(Object oParam, Exchange ex) throws IOException {
        Object o = oParam;
        String result = "";
        byte[] bresult = new byte[]{};
        boolean octets = this.shouldReadAsOctets;
        if (o != null) {
            if (o instanceof MultipartBody) {
                return "";
            }
            if (o instanceof Response) {
                MultivaluedMap meta = ((Response)o).getMetadata();
                if (meta != null) {
                    String ct = (String)meta.getFirst((Object)"Content-Type");
                    octets |= ct != null && ct.contains("application/octet-stream");
                }
                o = ((Response)o).getEntity();
            }
            if (o instanceof byte[]) {
                if (octets) {
                    bresult = (byte[])o;
                } else {
                    result = IOConverter.toString((byte[])((byte[])o), (Exchange)ex);
                }
            } else if (o instanceof InputStream) {
                if (octets) {
                    bresult = IOConverter.toBytes((InputStream)((InputStream)o));
                } else {
                    result = IOConverter.toString((InputStream)((InputStream)o), (Exchange)ex);
                }
            } else if (o != null) {
                if (octets) {
                    bresult = (byte[])ex.getContext().getTypeConverter().convertTo(byte[].class, ex, o);
                } else {
                    result = (String)ex.getContext().getTypeConverter().convertTo(String.class, ex, o);
                }
            }
        }
        if (octets) {
            return bresult;
        }
        return result;
    }

    @Override
    public void bindExchangeFromEsbResponse(Exchange exchange, XQMessage message) throws Exception {
        if (message.doesPartExist("SonicESB.RME")) {
            XQPart part = message.getPart("SonicESB.RME");
            this.populateBodyHeaderContentType(part, exchange);
            exchange.getOut().setHeader("CamelHttpResponseCode", (Object)500);
        } else if (message.containsHeader("SonicESB.Fault.Name")) {
            int responseCode;
            XQPart part;
            if (message.doesPartExist("Response")) {
                part = message.getPart("Response");
                this.populateBodyHeaderContentType(part, exchange);
            } else if (message.getPartCount() > 0) {
                part = message.getPart(0);
                this.populateBodyHeaderContentType(part, exchange);
            }
            try {
                responseCode = this.getResponseCodeForFault(message);
            }
            catch (Exception e) {
                responseCode = 500;
            }
            exchange.getOut().setHeader("CamelHttpResponseCode", (Object)responseCode);
        } else {
            if (message.doesPartExist("Response")) {
                XQPart part = message.getPart("Response");
                this.populateBodyHeaderContentType(part, exchange);
                Map<String, DataHandler> attachments = null;
                attachments = this.scanAttachmentFromXQMessage(exchange, message, false);
                if (attachments != null && attachments.size() > 0) {
                    for (Map.Entry<String, DataHandler> entry : attachments.entrySet()) {
                        AttachmentUtils.addAttachment(exchange, entry.getKey(), entry.getValue());
                    }
                    exchange.getOut().setBody(null);
                }
            }
            try {
                exchange.getOut().setHeader("CamelHttpResponseCode", (Object)this.getStatusCode(message));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.applyBindingRules(exchange, message, exchange.getOut(), false);
        }
        this.propagateHeadersFromXQMessage(message, exchange.getOut().getHeaders(), exchange);
    }

    private void populateBodyHeaderContentType(XQPart part, Exchange exchange) {
        if (part != null && part.getContent() != null) {
            exchange.getOut().setBody(part.getContent());
            exchange.getOut().setHeader("Content-Type", (Object)part.getContentType());
        }
    }

    private int getResponseCodeForFault(XQMessage message) throws Exception {
        try {
            return this.getFaultCode(message);
        }
        catch (Exception e) {
            return this.getStatusCode(message);
        }
    }

    private int getStatusCode(XQMessage message) throws Exception {
        return message.getIntHeader("StatusCode");
    }

    private int getFaultCode(XQMessage message) throws Exception {
        return message.getIntHeader("SonicESB.Fault.Code");
    }

    public boolean isErrorStatusCode(Integer sc) throws Exception {
        for (Range range : this.getErrorStatusRangesList()) {
            if (!range.contains(sc)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AttachmentReferencesDetection getAttachmentReferencesDetection() {
        return AttachmentReferencesDetection.SCAN_MESSAGE_PARTS;
    }

    protected Integer extractStatusCode(Exchange ex) {
        Integer rc;
        Message out = ex.getOut();
        if (out != null && (rc = (Integer)out.getHeader("CamelHttpResponseCode", Integer.class)) != null) {
            return rc;
        }
        if (ex.isFailed()) {
            return EsbUtils.getStatusCodeFromException(ex.getException());
        }
        return 200;
    }

    protected void setHttpRequestHeaders(Map<String, Object> answer, String method, String acceptParam, String contentType, String pathandquery) {
        String path;
        String accept = acceptParam;
        int idx = pathandquery.indexOf("?");
        String string = path = idx == -1 ? pathandquery : pathandquery.substring(0, idx);
        if (contentType != null) {
            answer.put("Content-Type", contentType);
        }
        answer.put("CamelHttpMethod", method);
        if (accept == null) {
            accept = "text/xml";
        }
        answer.put("CamelAcceptContentType", accept);
        answer.put("Accept", accept);
        if (accept.startsWith("multipart")) {
            answer.put("CamelCxfRsResponseClass", MultipartBody.class);
        }
        answer.put("CamelHttpPath", path);
    }

    protected String deriveRequestContentType(XQMessage message, String method) throws XQException {
        XQPart body;
        String answer = null;
        if (!"GET".equalsIgnoreCase(method)) {
            answer = "text/xml";
        }
        if (message.doesPartExist("PostData") && (body = message.getPart("PostData")) != null) {
            answer = body.getContentType();
        }
        return answer;
    }

    @Override
    public Map<String, DataHandler> bindRequestAttachmentsFromXQMessage(XQMessage xqMessage, Exchange exchange) throws Exception {
        return null;
    }

    private MultivaluedMap<String, String> getTemplateValues(Exchange exchange, XQMessage requestMsg) throws XQMessageException {
        MultivaluedMap templateValues = (MultivaluedMap)exchange.getProperty("URI_TEMPLATE_PARMS");
        if (templateValues == null) {
            templateValues = new MultivaluedHashMap();
            String camelHttpUri = (String)exchange.getMessage().getHeader("CamelHttpUri");
            String template = requestMsg.getStringHeader("URITemplate");
            if (camelHttpUri != null && template != null) {
                URITemplate uriTemplate = new URITemplate(template);
                uriTemplate.match(camelHttpUri, templateValues);
                exchange.setProperty("URI_TEMPLATE_PARMS", (Object)templateValues);
            }
        }
        return templateValues;
    }

    private void setTemplateHeaderValues(Exchange exchange, XQMessage requestMsg) throws XQMessageException {
        MultivaluedMap<String, String> templateValues = this.getTemplateValues(exchange, requestMsg);
        for (String key : templateValues.keySet()) {
            String value = (String)templateValues.getFirst((Object)key);
            requestMsg.setStringHeader(key, value);
        }
    }

    static {
        serrorStatusRangesList.add(new Range(new Integer(300), new Integer(Integer.MAX_VALUE)));
    }
}

