/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.progress.sonic.esb.camel.SoapHeaderFilteringRules;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.camel.component.cxf.common.header.SoapMessageHeaderFilter;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.SoapVersionFactory;
import org.apache.cxf.headers.Header;

public class SonicSoapMessageHeaderFilter
extends SoapMessageHeaderFilter {
    protected Set<SoapHeaderFilteringRules> includedFilteringRules;
    protected Set<String> inHeaderFilters;
    protected Set<String> outHeaderFilters;
    private SoapHeaderFilteringRules composedFilteringRules;

    public void filter(HeaderFilterStrategy.Direction direction, List<Header> headers) {
        if (headers == null) {
            return;
        }
        Iterator<Header> iterator = headers.iterator();
        block0: while (iterator.hasNext()) {
            Header header = iterator.next();
            if (!(header instanceof SoapHeader)) continue;
            SoapHeader soapHeader = (SoapHeader)SoapHeader.class.cast(header);
            if (HeaderFilterStrategy.Direction.IN == direction && this.getInHeaderFilters().contains(soapHeader.getName().toString()) || HeaderFilterStrategy.Direction.OUT == direction && this.getOutHeaderFilters().contains(soapHeader.getName().toString())) {
                iterator.remove();
                continue;
            }
            Iterator itv = SoapVersionFactory.getInstance().getVersions();
            while (itv.hasNext()) {
                SoapVersion version = (SoapVersion)itv.next();
                if (soapHeader.getActor() == null || !soapHeader.getActor().equals(version.getNextRole())) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    public Set<SoapHeaderFilteringRules> getIncludedFilteringRules() {
        return this.includedFilteringRules;
    }

    public void setIncludedFilteringRules(Set<SoapHeaderFilteringRules> includedFilteringRules) {
        this.includedFilteringRules = includedFilteringRules;
    }

    public Set<String> getInHeaderFilters() {
        return this.getComposedFilteringRules().getInHeaderFilters();
    }

    public void setInHeaderFilters(Set<String> inHeaderFilters) {
        this.inHeaderFilters = inHeaderFilters;
    }

    public Set<String> getOutHeaderFilters() {
        return this.getComposedFilteringRules().getOutHeaderFilters();
    }

    public void setOutHeaderFilters(Set<String> outHeaderFilters) {
        this.outHeaderFilters = outHeaderFilters;
    }

    private SoapHeaderFilteringRules getComposedFilteringRules() {
        if (this.composedFilteringRules == null) {
            this.composedFilteringRules = new SoapHeaderFilteringRules();
            if (this.includedFilteringRules != null) {
                for (SoapHeaderFilteringRules rules : this.includedFilteringRules) {
                    this.composedFilteringRules.getInHeaderFilters().addAll(rules.getInHeaderFilters());
                    this.composedFilteringRules.getOutHeaderFilters().addAll(rules.getOutHeaderFilters());
                }
            }
            if (this.inHeaderFilters != null) {
                this.composedFilteringRules.getInHeaderFilters().addAll(this.inHeaderFilters);
            }
            if (this.outHeaderFilters != null) {
                this.composedFilteringRules.getOutHeaderFilters().addAll(this.outHeaderFilters);
            }
        }
        return this.composedFilteringRules;
    }
}

