/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel.util;

import com.sonicsw.esb.expression.Expression;
import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.itinerary.mapping.MappingUtils;
import com.sonicsw.esb.process.mapping.InvocationContext;
import com.sonicsw.esb.process.mapping.ParameterValue;
import com.sonicsw.esb.process.mapping.ParameterValueMap;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.XQProcessContext;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xqimpl.service.XQProcessContextImpl;
import com.sonicsw.xqimpl.util.XQParametersImpl;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.CxfOperationException;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.service.model.BindingOperationInfo;

public final class EsbUtils {
    private static final transient Log LOG = LogFactory.getLog(EsbUtils.class);

    private EsbUtils() {
    }

    public static ParameterValueMap getInputParamValueMap(Exchange exchange) {
        ParameterValueMap pvm = null;
        InvocationContext ic = EsbUtils.getInvocationContext(exchange);
        if (EsbUtils.hasInvocationMapping(ic)) {
            pvm = ic.getInputParameterValues();
        }
        return pvm;
    }

    public static InvocationContext getInvocationContext(Exchange exchange) {
        XQServiceContext sc = EsbUtils.getServiceContext(exchange);
        if (sc != null) {
            return (InvocationContext)sc.getInvocationContext();
        }
        return null;
    }

    public static boolean hasInvocationMapping(InvocationContext sc) {
        return sc != null && (sc.getInputParameterValues() != null && sc.getInputParameterValues().getParameterValues().hasNext() || sc.getOutputParameterValues() != null && sc.getOutputParameterValues().getParameterValues().hasNext());
    }

    public static XQServiceContext getServiceContext(Exchange exchange) {
        return (XQServiceContext)exchange.getProperty(XQServiceContext.class.getName(), XQServiceContext.class);
    }

    public static XQProcessContext getProcessContext(Exchange exchange, XQServiceContext serviceContext, boolean create) {
        XQProcessContext processCtx = null;
        if (serviceContext != null) {
            processCtx = serviceContext.getProcessContext();
        }
        if (processCtx == null && (processCtx = (XQProcessContext)exchange.getProperty(XQProcessContext.class.getName(), XQProcessContext.class)) == null && create) {
            processCtx = new XQProcessContextImpl((XQParameters)new XQParametersImpl());
            exchange.setProperty(XQProcessContext.class.getName(), (Object)processCtx);
        }
        return processCtx;
    }

    public static Object getInputFromParamMapOrMsgBodyPart(Exchange exchange, XQMessage xqMessage, String name) throws XQMessageException {
        XQPart body;
        ParameterValueMap pvm = EsbUtils.getInputParamValueMap(exchange);
        ParameterValue pv = null;
        Object answer = null;
        if (pvm != null) {
            pv = pvm.getParameterValue(name);
        }
        if (pv != null) {
            answer = pv.getValue();
        } else if (xqMessage.doesPartExist(name) && (body = xqMessage.getPart(name)) != null) {
            answer = body.getContent();
        }
        return answer;
    }

    public static String getStringFromParamMap(ParameterValueMap pvm, XQMessage message, String name) throws XQMessageException {
        String answer = null;
        ParameterValue pv = null;
        if (pvm != null) {
            pv = pvm.getParameterValue(name);
        }
        if (pv != null) {
            answer = (String)pv.getValue();
        }
        return answer;
    }

    public static Object getObjectFromParamMapOrBodyPart(ParameterValueMap pvm, XQMessage message, String name) throws XQMessageException {
        Object answer = null;
        if (pvm != null) {
            answer = pvm.getParameterValue(name).getValue();
        } else {
            XQPart part = message.getPart(name);
            answer = part.getContent();
        }
        return answer;
    }

    public static boolean hasFaultMessage(Exchange result) {
        return result.isFailed();
    }

    public static Object extractResultHeader(Exchange result, String name) {
        Message m = result.getOut();
        if (m != null) {
            return m.getHeader(name);
        }
        return null;
    }

    public static Map<String, String> extractResultHeaders(Exchange exchange) {
        Map<String, String> result = new HashMap<String, String>();
        Exception outException = exchange.getException();
        if (outException != null && outException instanceof CxfOperationException) {
            result = ((CxfOperationException)outException).getResponseHeaders();
        }
        return result;
    }

    public static Object extractResultBody(Exchange result) throws Exception {
        ExchangePattern pattern = result.getPattern();
        Object answer = null;
        Exception outException = result.getException();
        if (outException != null) {
            result.setException(null);
            return EsbUtils.extractResultFromException(outException);
        }
        if (EsbUtils.hasFaultMessage(result)) {
            return result.getOut().getBody();
        }
        boolean notOut = pattern != null && !pattern.isOutCapable();
        boolean hasOut = result.hasOut();
        answer = hasOut && !notOut ? result.getOut().getBody() : (!hasOut && result.getPattern() == ExchangePattern.InOptionalOut ? null : result.getIn().getBody());
        return answer;
    }

    private static Object extractResultFromException(Exception exception) throws Exception {
        Response response = EsbUtils.getResponseFromException(exception);
        if (response != null && response.getEntity() != null) {
            return response;
        }
        if (exception instanceof CxfOperationException) {
            String responseBody = ((CxfOperationException)exception).getResponseBody();
            if (responseBody != null) {
                return responseBody;
            }
            return exception.toString();
        }
        Throwable cause = exception.getCause();
        if (cause != null) {
            if (cause instanceof WebApplicationException && cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof Fault && cause.getCause() != null) {
                return cause.getCause().toString();
            }
            return cause.toString();
        }
        throw ObjectHelper.wrapRuntimeCamelException((Throwable)exception);
    }

    private static Response getResponseFromException(Exception exception) {
        Response answer = null;
        if (exception instanceof WebApplicationException) {
            answer = ((WebApplicationException)exception).getResponse();
        }
        return answer;
    }

    public static int getStatusCodeFromException(Exception exception) {
        int answer = 500;
        if (exception instanceof WebApplicationException) {
            answer = ((WebApplicationException)exception).getResponse().getStatus();
        } else if (exception instanceof CxfOperationException) {
            answer = ((CxfOperationException)exception).getStatusCode();
        }
        return answer;
    }

    public static Object evaluate(String expression, XQMessage message, XQServiceContext sc) {
        Object retval;
        block2: {
            retval = null;
            try {
                Expression exp = MappingUtils.getStaticExpressionFactory().createExpression(MappingUtils.getStaticExpressionContext(), expression);
                retval = exp.getValue(MappingUtils.getExpressionContext((XQMessage)message, (XQServiceContext)sc));
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)("IGNORED: EL expression '" + expression + "'"), (Throwable)e);
            }
        }
        return retval;
    }

    public static void setExpressionValue(String expression, Object value, XQMessage message, Exchange exchange) throws Exception {
        Expression exp = MappingUtils.getStaticExpressionFactory().createExpression(MappingUtils.getStaticExpressionContext(), expression);
        XQServiceContext sc = EsbUtils.getServiceContext(exchange);
        ExpressionContext ec = MappingUtils.getExpressionContext((XQMessage)message, (XQServiceContext)sc);
        if (sc == null) {
            XQProcessContext procCtx = EsbUtils.getProcessContext(exchange, sc, true);
            ec.setValue((Object)"esbp", (Object)procCtx);
        }
        exp.setValue(ec, value);
    }

    public static boolean isRME(XQMessage message) throws XQMessageException {
        if (message.getPartCount() == 0) {
            return false;
        }
        String cid = message.getPart(0).getContentId();
        if (cid == null) {
            return false;
        }
        return cid.equals("SonicESB.RME");
    }

    public static boolean isFaulted(XQMessage message) throws XQMessageException {
        if (EsbUtils.isRME(message)) {
            return true;
        }
        return message.containsHeader("SonicESB.Fault.Name");
    }

    public static BindingOperationInfo getBindingOperationInfo(Exchange exchange) {
        BindingOperationInfo wrapped;
        BindingOperationInfo boi = (BindingOperationInfo)exchange.getProperty(BindingOperationInfo.class.getName(), BindingOperationInfo.class);
        if (boi != null && !boi.isUnwrappedCapable() && (wrapped = boi.getWrappedOperation()) != null) {
            boi = wrapped;
        }
        return boi;
    }
}

