/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.progress.sonic.esb.camel.AttachmentReferencesDetection;
import com.progress.sonic.esb.camel.BindingRuleBean;
import com.progress.sonic.esb.camel.BindingRules;
import com.progress.sonic.esb.camel.BindingStrategy;
import com.progress.sonic.esb.camel.util.AttachmentUtils;
import com.progress.sonic.esb.camel.util.EsbUtils;
import com.progress.sonic.esb.camel.util.HeaderUtils;
import com.progress.sonic.esb.service.connect.camel_sonicesb.BindingRule;
import com.progress.sonic.esb.service.connect.camel_sonicesb.LocationValueType;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.XQServiceContext;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.activation.DataHandler;
import javax.activation.MimeType;
import javax.activation.UnsupportedDataTypeException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.helpers.IOUtils;

public abstract class AbstractRuleBasedBindingStrategy
extends BindingRules
implements BindingStrategy,
HeaderFilterStrategyAware {
    private static Map<String, String> smimeTypeCoercionTable = new HashMap<String, String>();
    private static final transient Log LOG;
    protected HeaderFilterStrategy headerFilterStrategy;
    protected Map<String, String> camelToXqHeaderMap = new HashMap<String, String>();
    protected Map<String, String> xqToCamelHeaderMap = new HashMap<String, String>();
    protected AttachmentReferencesDetection attachmentReferencesDetection;
    private Map<String, String> mimeTypeCoercionTable = smimeTypeCoercionTable;
    private LockProtectedBindingRules composedInBindingRules = new LockProtectedBindingRules(RuleType.IN);
    private LockProtectedBindingRules composedOutBindingRules = new LockProtectedBindingRules(RuleType.OUT);
    private LockProtectedBindingRules composedInFaultBindingRules = new LockProtectedBindingRules(RuleType.FAULT_IN);
    private LockProtectedBindingRules composedOutFaultBindingRules = new LockProtectedBindingRules(RuleType.FAULT_OUT);
    private List<BindingRules> bindingRulesList;
    private boolean preserveAttachmentInputStream;

    public Map<String, String> getMimeTypeCoercionTable() {
        return this.mimeTypeCoercionTable;
    }

    public void setMimeTypeCoercionTable(Map<String, String> table) {
        this.mimeTypeCoercionTable = table;
    }

    public List<BindingRuleBean> getComposedInBindingRules() {
        return this.doGetComposedBindingRules(this.composedInBindingRules);
    }

    public List<BindingRuleBean> getComposedOutBindingRules() {
        return this.doGetComposedBindingRules(this.composedOutBindingRules);
    }

    public List<BindingRuleBean> getComposedInFaultBindingRules() {
        return this.doGetComposedBindingRules(this.composedInFaultBindingRules);
    }

    public List<BindingRuleBean> getComposedOutFaultBindingRules() {
        return this.doGetComposedBindingRules(this.composedOutFaultBindingRules);
    }

    private List<BindingRuleBean> doGetComposedBindingRules(LockProtectedBindingRules bindingRules) {
        bindingRules.getLock().readLock().lock();
        try {
            if (bindingRules.getBindingRules() == null) {
                this.initializeComposedBindingRules(bindingRules);
            }
            List list = bindingRules.getBindingRules();
            return list;
        }
        finally {
            bindingRules.getLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeComposedBindingRules(LockProtectedBindingRules bindingRules) {
        bindingRules.getLock().readLock().unlock();
        bindingRules.getLock().writeLock().lock();
        try {
            if (bindingRules.getBindingRules() != null) {
                return;
            }
            ArrayList<BindingRuleBean> bindingRuleBeans = new ArrayList<BindingRuleBean>();
            if (this.bindingRulesList != null) {
                block16: for (BindingRules rules : this.bindingRulesList) {
                    switch (bindingRules.getRuleType().ordinal()) {
                        case 2: {
                            if (rules.getInFaultBindingRules() == null) continue block16;
                            bindingRuleBeans.addAll(rules.getInFaultBindingRules());
                            continue block16;
                        }
                        case 3: {
                            if (rules.getOutFaultBindingRules() == null) continue block16;
                            bindingRuleBeans.addAll(rules.getOutFaultBindingRules());
                            continue block16;
                        }
                        case 0: {
                            if (rules.getInBindingRules() == null) continue block16;
                            bindingRuleBeans.addAll(rules.getInBindingRules());
                            continue block16;
                        }
                        case 1: {
                            if (rules.getOutBindingRules() == null) continue block16;
                            bindingRuleBeans.addAll(rules.getOutBindingRules());
                            continue block16;
                        }
                    }
                    LOG.warn((Object)("Unknown RuleType " + (Object)((Object)bindingRules.getRuleType())));
                }
            }
            switch (bindingRules.getRuleType().ordinal()) {
                case 2: {
                    if (this.inFaultBindingRules == null) break;
                    bindingRuleBeans.addAll(this.inFaultBindingRules);
                    break;
                }
                case 3: {
                    if (this.outFaultBindingRules == null) break;
                    bindingRuleBeans.addAll(this.outFaultBindingRules);
                    break;
                }
                case 0: {
                    if (this.inBindingRules == null) break;
                    bindingRuleBeans.addAll(this.inBindingRules);
                    break;
                }
                case 1: {
                    if (this.outBindingRules == null) break;
                    bindingRuleBeans.addAll(this.outBindingRules);
                    break;
                }
                default: {
                    LOG.warn((Object)("Unknown RuleType " + (Object)((Object)bindingRules.getRuleType())));
                }
            }
            bindingRules.setBindingRules(bindingRuleBeans);
        }
        finally {
            bindingRules.getLock().readLock().lock();
            bindingRules.getLock().writeLock().unlock();
        }
    }

    public void setInHeaderRenamingMap(Map<String, String> map) {
        this.camelToXqHeaderMap = map;
    }

    public Map<String, String> getInHeaderRenamingMap() {
        return this.camelToXqHeaderMap;
    }

    public void setOutHeaderRenamingMap(Map<String, String> map) {
        this.xqToCamelHeaderMap = map;
    }

    public Map<String, String> getOutHeaderRenamingMap() {
        return this.xqToCamelHeaderMap;
    }

    public List<BindingRules> getBindingRulesList() {
        return this.bindingRulesList;
    }

    public void setBindingRulesList(List<BindingRules> bindingRulesList) {
        this.bindingRulesList = bindingRulesList;
    }

    @Override
    public List<BindingRuleBean> getInBindingRules() {
        return this.getComposedInBindingRules();
    }

    @Override
    public List<BindingRuleBean> getOutBindingRules() {
        return this.getComposedOutBindingRules();
    }

    @Override
    public List<BindingRuleBean> getInFaultBindingRules() {
        return this.getComposedInFaultBindingRules();
    }

    @Override
    public List<BindingRuleBean> getOutFaultBindingRules() {
        return this.getComposedOutFaultBindingRules();
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public AttachmentReferencesDetection getAttachmentReferencesDetection() {
        return this.attachmentReferencesDetection;
    }

    public void setAttachmentReferencesDetection(AttachmentReferencesDetection attachmentReferencesDetection) {
        this.attachmentReferencesDetection = attachmentReferencesDetection;
    }

    @Override
    public Map<String, DataHandler> bindRequestAttachmentsFromXQMessage(XQMessage xqMessage, Exchange exchange) throws Exception {
        XQServiceContext sc;
        Map<String, DataHandler> answer = null;
        AttachmentReferencesDetection scanAction = this.getAttachmentReferencesDetection();
        if (AttachmentReferencesDetection.SCAN_MESSAGE_PARTS == scanAction || AttachmentReferencesDetection.BASE64_AS_ATTACHMENTS == scanAction) {
            answer = this.scanAttachments(scanAction, exchange, xqMessage, true);
        }
        if ((sc = EsbUtils.getServiceContext(exchange)) != null) {
            for (BindingRuleBean bean : this.getInBindingRules()) {
                TypeConverterRegistry registry;
                TypeConverter tc;
                BindingRule rule = bean.getBindingRule();
                if (rule.getTo().getValueType() != LocationValueType.CAMEL_ATTACHMENT || rule.getFrom().getValueType() != LocationValueType.EXPRESSION) continue;
                Object obj = EsbUtils.evaluate(rule.getFrom().getValue(), xqMessage, sc);
                if (obj != null && !(obj instanceof DataHandler) && (tc = (registry = exchange.getContext().getTypeConverterRegistry()).lookup(DataHandler.class, obj.getClass())) != null) {
                    obj = tc.convertTo(DataHandler.class, obj);
                }
                if (!(obj instanceof DataHandler)) continue;
                if (answer == null) {
                    answer = new HashMap<String, DataHandler>();
                }
                answer.put(rule.getTo().getValue(), (DataHandler)DataHandler.class.cast(obj));
            }
        }
        return answer;
    }

    protected void applyAttachmentToMessage(XQMessage msg, String id, DataHandler dh) throws Exception {
        if (msg.doesPartExist(id)) {
            msg.removePart(id);
        }
        XQPart attachment = msg.createPart();
        attachment.setContentId(id);
        if (this.isPreserveAttachmentInputStream()) {
            attachment.setDataHandler(dh);
        } else {
            String originalContentType;
            String base = originalContentType = dh.getContentType();
            String charset = "UTF-8";
            try {
                MimeType mt = new MimeType(originalContentType);
                base = mt.getBaseType();
                String c2 = mt.getParameter("charset");
                if (c2 != null) {
                    charset = c2;
                }
            }
            catch (Exception mt) {
                // empty catch block
            }
            String coercedContentType = this.coerceContentType(base);
            byte[] raw = this.readRawDataHandlerBytes(dh);
            if ("application/octet-stream".equals(coercedContentType)) {
                attachment.setContent((Object)raw, "application/octet-stream");
            } else {
                attachment.setContent((Object)new String(raw, charset), coercedContentType);
            }
            if (!originalContentType.equals(coercedContentType)) {
                attachment.getHeader().setValue("Origin-Content-Type", originalContentType);
            }
        }
        msg.addPart(attachment);
    }

    protected String coerceContentType(String contentType) {
        String coercedContentType = this.getMimeTypeCoercionTable().get(contentType);
        if (coercedContentType != null) {
            return coercedContentType;
        }
        return "application/octet-stream";
    }

    protected byte[] readRawDataHandlerBytes(DataHandler dh) throws Exception {
        InputStream is = null;
        try {
            is = dh.getInputStream();
            return IOUtils.readBytesFromStream((InputStream)is);
        }
        catch (UnsupportedDataTypeException unsupportedDataTypeException) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            dh.writeTo((OutputStream)baos);
            return baos.toByteArray();
        }
    }

    @Override
    public Map<String, Object> bindRequestHeadersFromXQMessage(XQMessage message, Exchange exchange) throws Exception {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        XQServiceContext sc = EsbUtils.getServiceContext(exchange);
        if (sc != null) {
            for (BindingRuleBean bean : this.getInBindingRules()) {
                BindingRule rule = bean.getBindingRule();
                if (rule.getTo().getValueType() == LocationValueType.CAMEL_TRANSPORT_HEADER && rule.getFrom().getValueType() == LocationValueType.EXPRESSION) {
                    Object obj = EsbUtils.evaluate(rule.getFrom().getValue(), message, sc);
                    if (obj == null) continue;
                    answer.put(rule.getTo().getValue(), obj);
                    continue;
                }
                if (rule.getTo().getValueType() != LocationValueType.CAMEL_EXCHANGE_PROPERTY || rule.getFrom().getValueType() != LocationValueType.EXPRESSION) continue;
                exchange.setProperty(rule.getTo().getValue(), EsbUtils.evaluate(rule.getFrom().getValue(), message, sc));
            }
        }
        this.propagateHeadersFromXQMessage(message, answer, exchange);
        return answer;
    }

    protected void propagateHeadersFromXQMessage(XQMessage message, Map<String, Object> camelHeaders, Exchange exchange) throws XQMessageException {
        HeaderUtils.propagateHeadersFromXQMessage(message, camelHeaders, exchange, this.headerFilterStrategy, this.xqToCamelHeaderMap);
    }

    @Override
    public Object bindRequestBodyFromXQMessage(XQMessage xqMessage, Exchange exchange) throws Exception {
        return xqMessage;
    }

    @Override
    public XQMessage bindResponseBodyFromCamelExchange(Exchange exchange) throws Exception {
        if (!exchange.hasOut()) {
            return null;
        }
        Message out = exchange.getMessage();
        XQMessage xqMessage = (XQMessage)out.getBody(XQMessage.class);
        if (xqMessage == null) {
            return xqMessage;
        }
        for (Map.Entry<String, DataHandler> entry : AttachmentUtils.getAttachments(exchange).entrySet()) {
            this.applyAttachmentToMessage(xqMessage, entry.getKey(), entry.getValue());
        }
        this.applyBindingRules(exchange, xqMessage, out, false);
        this.propagateHeadersFromCamel(out.getHeaders(), exchange, xqMessage);
        return xqMessage;
    }

    protected void propagateHeadersFromCamel(Map<String, Object> headers, Exchange exchange, XQMessage xqMessage) throws XQMessageException {
        HeaderUtils.propagateHeadersFromCamel(headers, exchange, xqMessage, this.headerFilterStrategy, this.camelToXqHeaderMap);
    }

    protected abstract Map<String, DataHandler> scanAttachments(AttachmentReferencesDetection var1, Exchange var2, XQMessage var3, boolean var4) throws Exception;

    @Override
    public void bindEsbRequestFromExchange(XQMessage requestMsg, Exchange exchange) throws Exception {
        for (Map.Entry<String, DataHandler> entry : AttachmentUtils.getAttachments(exchange).entrySet()) {
            this.applyAttachmentToMessage(requestMsg, entry.getKey(), entry.getValue());
        }
        this.applyBindingRules(exchange, requestMsg, exchange.getIn(), true);
        this.propagateHeadersFromCamel(exchange.getIn().getHeaders(), exchange, requestMsg);
    }

    @Override
    public void bindExchangeFromEsbResponse(Exchange exchange, XQMessage message) throws Exception {
        exchange.getMessage().setBody((Object)message);
        Map<String, DataHandler> attachments = null;
        AttachmentReferencesDetection scanAction = this.getAttachmentReferencesDetection();
        if (AttachmentReferencesDetection.SCAN_MESSAGE_PARTS == scanAction || AttachmentReferencesDetection.BASE64_AS_ATTACHMENTS == scanAction) {
            attachments = this.scanAttachments(scanAction, exchange, message, false);
        }
        if (attachments != null) {
            for (Map.Entry attachEntry : attachments.entrySet()) {
                AttachmentUtils.addAttachment(exchange, (String)attachEntry.getKey(), (DataHandler)attachEntry.getValue());
            }
        }
        this.applyBindingRules(exchange, message, exchange.getMessage(), false);
        this.propagateHeadersFromXQMessage(message, exchange.getMessage().getHeaders(), exchange);
    }

    protected void applyBindingRules(Exchange exchange, XQMessage xqMessage, Message camelMessage, boolean isRequest) throws Exception {
        block10: for (BindingRuleBean bean : isRequest ? this.getInBindingRules() : this.getOutBindingRules()) {
            BindingRule rule = bean.getBindingRule();
            if (rule.getFrom().getValueType() == LocationValueType.EXPRESSION) {
                switch (rule.getTo().getValueType()) {
                    case CAMEL_TRANSPORT_HEADER: {
                        camelMessage.setHeader(rule.getTo().getValue(), EsbUtils.evaluate(rule.getFrom().getValue(), xqMessage, EsbUtils.getServiceContext(exchange)));
                        continue block10;
                    }
                    case CAMEL_EXCHANGE_PROPERTY: {
                        exchange.setProperty(rule.getTo().getValue(), EsbUtils.evaluate(rule.getFrom().getValue(), xqMessage, EsbUtils.getServiceContext(exchange)));
                        continue block10;
                    }
                    case CAMEL_ATTACHMENT: {
                        AttachmentUtils.addAttachment(camelMessage.getExchange(), rule.getTo().getValue(), (DataHandler)EsbUtils.evaluate(rule.getFrom().getValue(), xqMessage, EsbUtils.getServiceContext(exchange)));
                        continue block10;
                    }
                }
                continue;
            }
            if (rule.getTo().getValueType() != LocationValueType.EXPRESSION) continue;
            Object value = null;
            switch (rule.getFrom().getValueType()) {
                case CAMEL_TRANSPORT_HEADER: {
                    value = camelMessage.getHeader(rule.getFrom().getValue());
                    break;
                }
                case CAMEL_EXCHANGE_PROPERTY: {
                    value = exchange.getProperty(rule.getFrom().getValue());
                    break;
                }
                case CAMEL_ATTACHMENT: {
                    value = AttachmentUtils.getAttachment(exchange, rule.getFrom().getValue());
                    break;
                }
            }
            if (value == null) continue;
            EsbUtils.setExpressionValue(rule.getTo().getValue(), value, xqMessage, exchange);
        }
    }

    public void setPreserveAttachmentInputStream(boolean preserveAttachmentInputStream) {
        this.preserveAttachmentInputStream = preserveAttachmentInputStream;
    }

    public boolean isPreserveAttachmentInputStream() {
        return this.preserveAttachmentInputStream;
    }

    static {
        smimeTypeCoercionTable.put("text/plain", "text/plain");
        smimeTypeCoercionTable.put("application/json", "text/plain");
        smimeTypeCoercionTable.put("application/x-www-form-urlencoded", "text/plain");
        smimeTypeCoercionTable.put("application/xml", "text/xml");
        smimeTypeCoercionTable.put("text/xml", "text/xml");
        LOG = LogFactory.getLog(AbstractRuleBasedBindingStrategy.class);
    }

    private final class LockProtectedBindingRules {
        private List<BindingRuleBean> bindingRules;
        private ReadWriteLock lock = new ReentrantReadWriteLock();
        private RuleType ruleType;

        private LockProtectedBindingRules(RuleType type) {
            this.ruleType = type;
        }

        private void setBindingRules(List<BindingRuleBean> bindingRules) {
            this.bindingRules = bindingRules;
        }

        private List<BindingRuleBean> getBindingRules() {
            return this.bindingRules;
        }

        private ReadWriteLock getLock() {
            return this.lock;
        }

        private RuleType getRuleType() {
            return this.ruleType;
        }
    }

    private static enum RuleType {
        IN,
        OUT,
        FAULT_IN,
        FAULT_OUT;

    }
}

