/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.actional.lg.interceptor.sdk.ServerInteraction;
import com.progress.sonic.esb.camel.AsyncResponseHandler;
import com.progress.sonic.esb.camel.BindingStrategy;
import com.progress.sonic.esb.camel.EsbMessageExchange;
import com.progress.sonic.esb.camel.SonicEsbComponent;
import com.progress.sonic.esb.camel.SonicEsbEndpoint;
import com.progress.sonic.esb.camel.SonicEsbURI;
import com.progress.sonic.esb.camel.converter.XQMessageConverter;
import com.progress.sonic.esb.camel.util.EsbUtils;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xqimpl.actional.lg.visitor.ActionalRuntimeContext;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SonicEsbProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(SonicEsbProducer.class);

    public SonicEsbProducer(SonicEsbEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Process exchange: " + exchange));
        }
        SonicEsbEndpoint ep = (SonicEsbEndpoint)this.getEndpoint();
        long startTime = System.currentTimeMillis();
        boolean success = false;
        try {
            Integer code;
            XQMessage requestMsg;
            if (ep.getStatsCollector() != null) {
                ep.getStatsCollector().processingStarts();
            }
            XQInitContext initContext = ep.getXQInitContext();
            ObjectHelper.notNull((Object)initContext, (String)XQInitContext.class.getName());
            exchange.setProperty(XQInitContext.class.getName(), (Object)initContext);
            SonicEsbURI sonicURI = new SonicEsbURI(this.getEndpoint(), initContext.getAddressFactory());
            exchange.setProperty("sonicesb-uri-object", (Object)sonicURI);
            Message inMessage = exchange.getIn();
            BindingStrategy binding = (BindingStrategy)exchange.getProperty(BindingStrategy.class.getName(), BindingStrategy.class);
            if (binding == null) {
                binding = ep.getBindingStrategy();
                exchange.setProperty(BindingStrategy.class.getName(), (Object)binding);
            }
            if ((requestMsg = (XQMessage)inMessage.getBody(XQMessage.class)) == null) {
                requestMsg = inMessage.getBody() != null ? XQMessageConverter.toXQMessage(false, exchange) : XQMessageConverter.toXQMessage("", exchange);
            }
            binding.bindEsbRequestFromExchange(requestMsg, exchange);
            ServerInteraction serverInteraction = ServerInteraction.get();
            if (serverInteraction != null) {
                ActionalRuntimeContext actionalRuntimeContext = new ActionalRuntimeContext();
                actionalRuntimeContext.setParentServerInteractionStub(serverInteraction.split());
                XQMessageInternal xqMessageInteral = (XQMessageInternal)requestMsg;
                xqMessageInteral.addSidebandProperty("ESBVisitor.PARAM_RUNTIME_CONTEXT", (Object)actionalRuntimeContext);
            }
            exchange.setProperty(AsyncResponseHandler.class.getName(), (Object)ep.getAsyncResponseHandler());
            SonicEsbComponent component = (SonicEsbComponent)ep.getComponent();
            EsbMessageExchange esgMex = component.getEsbMessageExchangeFactory().createEsbMessageExchange(exchange, ep);
            XQMessage[] responseMessages = null;
            responseMessages = esgMex.send(exchange, requestMsg, ep);
            if (exchange.getPattern().isOutCapable() && responseMessages != null && responseMessages.length > 0) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Process response " + exchange));
                }
                binding.bindExchangeFromEsbResponse(exchange, responseMessages[0]);
            }
            if ((success = responseMessages == null || responseMessages.length <= 0 || !EsbUtils.isFaulted(responseMessages[0])) && exchange.hasOut() && (code = (Integer)exchange.getMessage().getHeader("CamelHttpResponseCode", Integer.class)) != null && code >= 300 && code <= 999) {
                success = false;
            }
        }
        catch (Exception e) {
            success = false;
            throw e;
        }
        finally {
            if (ep.getStatsCollector() != null) {
                if (success) {
                    ep.getStatsCollector().processingEnds(System.currentTimeMillis() - startTime);
                } else {
                    ep.getStatsCollector().processingFaulted();
                }
            }
        }
    }
}

