/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.sonic.esb.connect.processor;

import com.aurea.sonic.esb.annotation.util.ProcessorContext;
import com.aurea.sonic.esb.connect.annotation.SonicConnect;
import com.aurea.sonic.esb.connect.processor.ConnectServiceGenerator;
import com.aurea.sonic.esb.connect.processor.ConnectServiceValidator;
import com.aurea.sonic.esb.connect.processor.model.ConnectModel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class AnnotationProcessor
extends AbstractProcessor {
    private ProcessorContext context;
    private ConnectServiceGenerator generator;
    private ConnectServiceValidator validator;
    private Map<Element, ConnectModel> services;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.context = new ProcessorContext(processingEnv);
        this.generator = new ConnectServiceGenerator(this.context);
        this.validator = new ConnectServiceValidator(this.context);
        this.services = new LinkedHashMap<Element, ConnectModel>();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(SonicConnect.class.getCanonicalName());
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(SonicConnect.class)) {
            ConnectModel service = new ConnectModel(this.context, element);
            this.services.put(service.getType(), service);
        }
        if (roundEnv.processingOver()) {
            ArrayList<ConnectModel> generatedServices = new ArrayList<ConnectModel>();
            for (ConnectModel service : this.services.values()) {
                if (!this.validator.validateService(service) || !this.generator.generateService(service)) continue;
                generatedServices.add(service);
            }
            if (!generatedServices.isEmpty()) {
                this.generator.generateSpringConfig(generatedServices);
            }
            this.services.clear();
        }
        return true;
    }
}

