// =====================================================================================================================
// Copyright (c) 2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
// =====================================================================================================================

package com.aurea.sonic.esb.connect.processor.model;

import com.aurea.sonic.esb.connect.annotation.SonicConnect;

/**
 * <!-- ========================================================================================================== -->
 * Parameter Model of {@linkplain SonicConnect}
 * <!-- --------------------------------------------------------------------------------------------------------- -->
 */
public class ParameterModel {

	private final String name;

	private final String type;

	private final ParameterKind kind;

	public ParameterModel(final String name, final String type, final ParameterKind kind) {
		this.name = name;
		this.type = type;
		this.kind = kind;
	}

	public String getName() {
		return name;
	}

	public String getType() {
		return type;
	}

	public ParameterKind getKind() {
		return kind;
	}

	/**
	 * <!-- ================================================================================================== -->
	* {@inheritDoc}
	* <!-- ------------------------------------------------------------------------------------------------- -->
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}

	/**
	 * <!-- ================================================================================================== -->
	* {@inheritDoc}
	* <!-- ------------------------------------------------------------------------------------------------- -->
	 */
	@Override
	public boolean equals(final Object obj) {
		if (this == obj)
		{
			return true;
		}
		if (obj == null)
		{
			return false;
		}
		if (getClass() != obj.getClass())
		{
			return false;
		}
		final ParameterModel other = (ParameterModel) obj;
		if (name == null) {
			if (other.name != null)
			{
				return false;
			}
		} else if (!name.equals(other.name))
		{
			return false;
		}
		return true;
	}

	/**
	 * <!-- ================================================================================================== -->
	* {@inheritDoc}
	* <!-- ------------------------------------------------------------------------------------------------- -->
	 */
	@Override
	public String toString() {
		return "ParameterModel [name=" + name + ", type=" + type + ", kind=" + kind + "]";
	}

}
