/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;

public class SFCDiagnosticContext {
    private static ThreadLocalProperties threadProperties = new ThreadLocalProperties();
    private static Logger logger = LogManager.getLogger(SFCDiagnosticContext.class);

    public static Properties set(Properties props) {
        Properties previous = SFCDiagnosticContext.remove();
        if (props != null && props.size() > 0) {
            threadProperties.set(props);
            SFCDiagnosticContext.addToMDC();
        }
        return previous;
    }

    public static Properties get() {
        return threadProperties.getProperties();
    }

    public static Properties remove() {
        SFCDiagnosticContext.removeFromMDC();
        Properties props = threadProperties.getProperties();
        threadProperties.set(null);
        return props;
    }

    private static void addToMDC() {
        Map map = SFCDiagnosticContext.asMap();
        for (String key : map.keySet()) {
            String value = (String)map.get(key);
            if (value == null) continue;
            ThreadContext.put((String)key, (String)((String)map.get(key)));
        }
    }

    private static void removeFromMDC() {
        Map map = SFCDiagnosticContext.asMap();
        for (String key : map.keySet()) {
            ThreadContext.remove((String)key);
        }
    }

    public static Map asMap() {
        Properties map = threadProperties.getProperties();
        return map != null ? Collections.unmodifiableMap(map) : Collections.EMPTY_MAP;
    }

    public static void writeToLog() {
        if (logger.isEnabled(Level.DEBUG)) {
            MessageFormat pattern = new MessageFormat("Diagnostic Context: {0} = {1}");
            Properties props = threadProperties.getProperties();
            for (String string : props.keySet()) {
                logger.debug(pattern.format(new Object[]{string, props.get(string)}));
            }
        }
    }

    private static class ThreadLocalProperties
    extends InheritableThreadLocal {
        private ThreadLocalProperties() {
        }

        protected Object childValue(Object current) {
            if (current != null) {
                return ((Properties)current).clone();
            }
            return null;
        }

        public Properties getProperties() {
            return (Properties)super.get();
        }

        @Override
        protected Object initialValue() {
            return new Properties();
        }
    }
}

