/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.service.common.SFCParameters;
import com.sonicsw.esb.service.common.SFCServiceException;
import com.sonicsw.esb.service.common.impl.AbstractSFCParametersImpl;
import com.sonicsw.esb.service.common.util.CheckArg;
import com.sonicsw.esb.service.common.util.variables.VariableParser;
import com.sonicsw.xq.XQParameterInfo;
import com.sonicsw.xq.XQParameters;
import java.util.Stack;

class ScopedParameters
extends AbstractSFCParametersImpl {
    private static final SFCParameters EMPTY_SCOPE = new EmptyParameters();
    private SFCParameters currentScope;
    private final Stack parentScopes = new Stack();

    public ScopedParameters(SFCParameters params) {
        this.currentScope = params;
    }

    public ScopedParameters(SFCParameters params, VariableParser variableParser) {
        this(params);
        this.initVariableParser(variableParser);
    }

    private void initVariableParser(VariableParser variableParser) {
        this.setVariableParser(variableParser);
    }

    @Override
    public String getParameter(String paramName) throws SFCServiceException {
        SFCParameters scope = this.findScope(paramName);
        while (EMPTY_SCOPE != scope) {
            XQParameterInfo info = scope.getInfo(paramName);
            String result = this.getParameter(info);
            if (result != null) {
                return result;
            }
            scope = this.findNextScope(paramName, scope);
        }
        return null;
    }

    @Override
    public Object getParameterObject(String paramName) throws SFCServiceException {
        SFCParameters scope = this.findScope(paramName);
        while (EMPTY_SCOPE != scope) {
            XQParameterInfo info = scope.getInfo(paramName);
            Object result = this.getParameterObject(info);
            if (result != null) {
                return result;
            }
            scope = this.findNextScope(paramName, scope);
        }
        return null;
    }

    @Override
    public String getReference(String paramName) {
        SFCParameters scope = this.findScope(paramName);
        while (EMPTY_SCOPE != scope) {
            XQParameterInfo info = scope.getInfo(paramName);
            String result = this.getReference(info);
            if (result != null) {
                return result;
            }
            scope = this.findNextScope(paramName, scope);
        }
        return null;
    }

    public void push(SFCParameters params) {
        CheckArg.notNull(params, "params");
        this.parentScopes.push(this.currentScope);
        this.currentScope = params;
    }

    public void pop() {
        if (this.parentScopes.isEmpty()) {
            throw new IllegalStateException("Unable to pop: there is only one scope.");
        }
        this.currentScope = (SFCParameters)this.parentScopes.pop();
    }

    @Override
    public boolean contains(String paramName) {
        return EMPTY_SCOPE != this.findScope(paramName);
    }

    @Override
    public XQParameterInfo getInfo(String paramName) {
        return this.findScope(paramName).getInfo(paramName);
    }

    @Override
    public XQParameters getXQParameters() {
        return this.currentScope.getXQParameters();
    }

    private SFCParameters findScope(String paramName) {
        return this.findScope(paramName, this.currentScope, true);
    }

    private SFCParameters findNextScope(String paramName, SFCParameters prevScope) {
        return this.findScope(paramName, prevScope, false);
    }

    private SFCParameters findScope(String paramName, SFCParameters startAt, boolean includeStart) {
        boolean foundStart;
        boolean bl = foundStart = startAt == this.currentScope;
        if (foundStart && includeStart && this.currentScope.contains(paramName)) {
            return this.currentScope;
        }
        for (int i = this.parentScopes.size() - 1; i >= 0; --i) {
            SFCParameters scope = (SFCParameters)this.parentScopes.get(i);
            if (!foundStart && scope == startAt) {
                foundStart = true;
                if (!includeStart) continue;
            }
            if (!foundStart || !scope.contains(paramName)) continue;
            return scope;
        }
        return EMPTY_SCOPE;
    }

    private static final class EmptyParameters
    extends AbstractSFCParametersImpl {
        private EmptyParameters() {
        }

        @Override
        public boolean contains(String parameterName) {
            return false;
        }

        @Override
        public XQParameterInfo getInfo(String parameterName) {
            return null;
        }

        @Override
        public XQParameters getXQParameters() {
            return null;
        }
    }
}

