/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.ramps.impl;

import com.sonicsw.esb.service.common.SFCParameters;
import com.sonicsw.esb.service.common.ramps.TimeoutException;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQServiceException;

public final class OnRampParameter {
    private static final int MILLIES_PER_SEC = 1000;
    private boolean timeoutIsError_;
    private int timeout_;
    private int maxMessages_;

    public OnRampParameter(int _defaultMaxMessages) {
        this.maxMessages_ = _defaultMaxMessages;
        this.timeout_ = 0;
    }

    public void init(SFCParameters _params) {
        this.initTimeoutMode(_params);
        this.initTimeout(_params);
        this.initMaxMessages(_params);
    }

    private void initMaxMessages(SFCParameters _params) {
        String maxMessageValue = _params.getParameter("MaxNumberOfMessages", Integer.toString(this.maxMessages_));
        int maxMessages = Integer.parseInt(maxMessageValue);
        if (maxMessages < 0) {
            this.maxMessages_ = -1;
        } else {
            if (maxMessages == 0) {
                throw new IllegalArgumentException("You cannot specify an maximum number of messages of zero (0).");
            }
            this.maxMessages_ = maxMessages;
        }
    }

    private void initTimeout(SFCParameters _params) {
        String timeoutValue = _params.getParameter("WaitTimeout", Integer.toString(this.timeout_));
        int timeout = Integer.parseInt(timeoutValue);
        this.timeout_ = timeout < 0 ? -1 : (timeout == 0 ? 0 : 1000 * timeout);
    }

    private void initTimeoutMode(SFCParameters _params) {
        String timeoutModeValue = _params.getParameter("TimeoutMode", "Error");
        if (!"Continue".equals(timeoutModeValue) && !"Error".equals(timeoutModeValue)) {
            throw new IllegalArgumentException("The value of TimeoutMode must be one of 'Continue' or 'Error' but is " + timeoutModeValue);
        }
        this.timeoutIsError_ = "Error".equals(timeoutModeValue);
    }

    public int getTimeout() {
        return this.timeout_;
    }

    public int getMaxMessages() {
        return this.maxMessages_;
    }

    public void validateMessageCount(XQMessage[] _messagesToSend) {
        if (-1 != this.maxMessages_ && _messagesToSend.length > this.maxMessages_) {
            throw new IllegalStateException("SyncOnRamp did produce more messages than allowed.");
        }
    }

    public void handleTimeout(TimeoutException _e) throws XQServiceException {
        if (this.timeoutIsError_) {
            throw new XQServiceException("Timeout occured.", (Throwable)_e);
        }
    }
}

