/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.ramps.impl;

import com.sonicsw.esb.service.common.ramps.impl.Listener;
import java.util.Properties;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.impl.StdSchedulerFactory;

public final class QuartzUtils {
    private QuartzUtils() {
    }

    public static Scheduler getScheduler(int _threadPoolSize) throws SchedulerException {
        Properties props = new Properties();
        props.setProperty("org.quartz.scheduler.instanceName", "SonicESB Ramps");
        props.setProperty("org.quartz.threadPool.threadCount", String.valueOf(_threadPoolSize));
        StdSchedulerFactory schedFact = new StdSchedulerFactory();
        Scheduler scheduler = schedFact.getScheduler();
        QuartzUtils.addLoggerIfNeeded(scheduler);
        return scheduler;
    }

    private static void addLoggerIfNeeded(Scheduler _scheduler) throws SchedulerException {
        SchedulerListener old = null;
        for (SchedulerListener listener : _scheduler.getSchedulerListeners()) {
            if (!(listener instanceof Listener)) continue;
            old = listener;
        }
        if (null != old) {
            _scheduler.removeSchedulerListener(old);
        }
        _scheduler.addSchedulerListener((SchedulerListener)new Listener());
    }
}

