/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.ramps.pools;

import com.sonicsw.esb.service.common.ramps.IConnectionContext;
import com.sonicsw.esb.service.common.ramps.pools.AbstractKeyedPoolConnectionFactory;
import com.sonicsw.esb.service.common.ramps.pools.IPoolableConnectionContext;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public final class KeyedPoolableConnectionFactory
implements KeyedPooledObjectFactory {
    public PooledObject makeObject(Object _key) throws Exception {
        this.validateKey(_key);
        AbstractKeyedPoolConnectionFactory.PoolKey key = (AbstractKeyedPoolConnectionFactory.PoolKey)_key;
        IConnectionContext connection = key.getFactory().createConnection(key.getContext());
        connection.activate();
        return new DefaultPooledObject((Object)connection);
    }

    public void activateObject(Object _key, PooledObject _connection) throws Exception {
    }

    public boolean validateObject(Object _key, PooledObject _connection) {
        if (_connection != null && _connection.getObject() instanceof IPoolableConnectionContext) {
            return ((IPoolableConnectionContext)_connection.getObject()).validate();
        }
        return true;
    }

    public void passivateObject(Object _key, PooledObject _connection) throws Exception {
    }

    public void destroyObject(Object _key, PooledObject _connection) throws Exception {
        if (_connection == null || !(_connection.getObject() instanceof IConnectionContext)) {
            throw new IllegalArgumentException("Not a connection object");
        }
        this.validateKey(_key);
        AbstractKeyedPoolConnectionFactory.PoolKey key = (AbstractKeyedPoolConnectionFactory.PoolKey)_key;
        ((IConnectionContext)_connection.getObject()).deactivate(true);
        key.getFactory().destroyConnection((IConnectionContext)_connection.getObject(), true);
    }

    private void validateKey(Object _key) {
        if (!(_key instanceof AbstractKeyedPoolConnectionFactory.PoolKey)) {
            throw new IllegalArgumentException("The key provided is not a pool key from the ramps.");
        }
    }
}

