/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.ramps.servicetype;

import com.sonicsw.esb.service.common.SFCInitializationContext;
import com.sonicsw.esb.service.common.SFCService;
import com.sonicsw.esb.service.common.SFCServiceContext;
import com.sonicsw.esb.service.common.impl.AbstractSFCServiceImpl;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQParameterInfo;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xqimpl.service.ESBSpringUtils;
import com.sonicsw.xqimpl.util.spring.SonicResourceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ResourceLoader;

public class ServiceTypeWrapper
extends AbstractSFCServiceImpl {
    private static final Logger LOGGER = LogManager.getLogger(ServiceTypeWrapper.class);
    public static final String SPRING_BEAN_SERVICE_FACTORY_NAME = "xqServiceFactory";
    public static final String PARAM_SPRING_CONFIG = "springConfig";
    private ApplicationContext parentContext_;
    private AbstractApplicationContext localContext_;
    private SFCService serviceDelegate_;

    @Override
    public void doInit(SFCInitializationContext _ctx) throws XQServiceException {
        LOGGER.debug("doInit...");
        GenericApplicationContext ctx = ESBSpringUtils.createApplicationContext((String)("Ramps_" + _ctx.getServiceName()), (ResourceLoader)new SonicResourceLoader());
        if (null != this.parentContext_) {
            ctx.setParent(this.parentContext_);
        }
        if (!this.readBeanConfigFromParam(_ctx, ctx)) {
            ESBSpringUtils.readBeanConfigurationsFromClassPath((String)("classpath*:config/esb/" + _ctx.getServiceTypeName() + "-applicationContext.xml"), (BeanDefinitionRegistry)ctx);
        }
        this.registerSelfAsBeanFactory(ctx);
        ctx.refresh();
        this.localContext_ = ctx;
        this.dumpSingletons((AbstractApplicationContext)ctx);
        super.writeStartupMessage();
        if (null == this.serviceDelegate_) {
            throw new IllegalStateException("Configuring from spring did not succeed in setting the service delegate.");
        }
        this.serviceDelegate_.doInit(_ctx);
        LOGGER.debug("doInit done.");
    }

    @Override
    protected void writeStartupMessage() {
    }

    private boolean readBeanConfigFromParam(SFCInitializationContext _ctx, GenericApplicationContext _context) {
        XQParameterInfo param = _ctx.getParameters().getInfo(PARAM_SPRING_CONFIG);
        if (null != param) {
            String configLocation = param.getRef();
            if (configLocation == null) {
                configLocation = param.getValue();
            }
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)_context);
            try {
                return reader.loadBeanDefinitions(configLocation) > 0;
            }
            catch (BeanDefinitionStoreException beanDefinitionStoreException) {
                // empty catch block
            }
        }
        return false;
    }

    private void dumpSingletons(AbstractApplicationContext _ctx) {
        StringBuffer stringBuffer = new StringBuffer("Listing singletons for Spring application context");
        stringBuffer.append(_ctx.getDisplayName());
        stringBuffer.append('\n');
        String[] singletonNames = _ctx.getBeanFactory().getSingletonNames();
        for (int i = 0; i < singletonNames.length; ++i) {
            stringBuffer.append("\tFound singleton with name ").append(singletonNames[i]).append('\n');
        }
        LOGGER.debug(stringBuffer.toString());
        ApplicationContext parent = _ctx.getParent();
        if (parent instanceof AbstractApplicationContext) {
            this.dumpSingletons((AbstractApplicationContext)parent);
        }
    }

    private void registerSelfAsBeanFactory(GenericApplicationContext _ctx) {
        _ctx.getBeanFactory().registerSingleton(SPRING_BEAN_SERVICE_FACTORY_NAME, (Object)this);
    }

    @Override
    public void doDestroy() throws XQServiceException {
        if (null != this.localContext_) {
            this.localContext_.close();
        }
        LOGGER.debug("doDestroy");
    }

    protected void finalize() throws Throwable {
        this.doDestroy();
        super.finalize();
    }

    @Override
    public void doService(SFCServiceContext _context, XQEnvelope _envelope) throws XQServiceException {
        throw new IllegalStateException("This should never be called. Rather the serviceDelegate will handle it. This method is just here to satisfy the abstract class requirements.");
    }

    @Override
    public void setServiceDelegate(SFCService _serviceDelegate) {
        super.setServiceDelegate(_serviceDelegate);
        this.serviceDelegate_ = _serviceDelegate;
    }

    @Override
    public void setApplicationContext(ApplicationContext _applicationContext) {
        super.setApplicationContext(_applicationContext);
        this.parentContext_ = _applicationContext;
    }

    public final Object getInstance() {
        return this;
    }
}

