/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.util.message.impl;

import com.sonicsw.esb.service.common.util.message.EsbMsgUtilsContext;
import com.sonicsw.esb.service.common.util.message.EsbMsgUtilsException;
import com.sonicsw.esb.service.common.util.message.XQMessageToXml;
import com.sonicsw.esbmsg.message.EsbmsgDocument;
import com.sonicsw.esbmsg.message.HeaderType;
import com.sonicsw.esbmsg.message.MessageType;
import com.sonicsw.esbmsg.message.PartDocument;
import com.sonicsw.esbmsg.message.PartType;
import com.sonicsw.xq.XQHeader;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlString;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XQMessageToXmlImpl
implements XQMessageToXml {
    private static final String URI = "http://www.sonicsw.com/esbmsg/message";

    @Override
    public Document getAsDocument(XQMessage msg) throws EsbMsgUtilsException {
        return this.getXQMessageToXmlConverter(msg);
    }

    @Override
    public Document getAsDocument(XQPart part) throws EsbMsgUtilsException {
        return this.getXQPartToXmlConverter(part);
    }

    @Override
    public String getXQMessageString(XQMessage msg) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("To get String representation for the XQMessage");
        ctx.setXqmessage(msg);
        ctx.setOperation("Convert XQMessage to String Representation");
        try {
            Document document = this.getXQMessageToXmlConverter(msg);
            return this.getString(document).toString();
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to get String representation for the XQMessage xml Document", e);
        }
    }

    @Override
    public String getXQPartString(XQPart part) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("To get String representation for the XQPart");
        ctx.setXqpart(part);
        ctx.setOperation("Convert XQpart to String representation");
        try {
            Document document = this.getXQPartToXmlConverter(part);
            return this.getString(document).toString();
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to get String representation for the XQPart xml Document", e, ctx);
        }
    }

    private StringWriter getString(Document doc) {
        StringWriter sw = new StringWriter();
        DOMUtils.serializeNodeToWriter((Node)doc.getDocumentElement(), (Writer)sw);
        sw.flush();
        return sw;
    }

    private Document getXQPartToXmlConverter(XQPart part) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("To convert XQPart to Xml");
        ctx.setXqpart(part);
        ctx.setOperation("Convert XQPart to Document");
        try {
            PartDocument partDoc = PartDocument.Factory.newInstance();
            PartType esbmsgPart = partDoc.addNewPart();
            XmlCursor xmlcurPart = esbmsgPart.newCursor();
            xmlcurPart.toNextToken();
            xmlcurPart.insertNamespace("", URI);
            xmlcurPart.dispose();
            this.setPartType(esbmsgPart, part);
            Node partNode = esbmsgPart.getDomNode();
            return partNode.getOwnerDocument();
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Cannot create Document from XQPart", e, ctx);
        }
    }

    private Document getXQMessageToXmlConverter(XQMessage msg) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("To convert XQMessage to Xml");
        ctx.setXqmessage(msg);
        ctx.setOperation("Convert XQMessage to Document");
        try {
            EsbmsgDocument esbDoc = EsbmsgDocument.Factory.newInstance();
            EsbmsgDocument.Esbmsg esbmsg = esbDoc.addNewEsbmsg();
            XmlCursor xmlcurMsg = esbmsg.newCursor();
            xmlcurMsg.toNextToken();
            xmlcurMsg.insertNamespace("", URI);
            xmlcurMsg.dispose();
            for (int i = 0; i < msg.getPartCount(); ++i) {
                PartType esbmsgPart = esbmsg.addNewPart();
                XQPart part = msg.getPart(i);
                this.setPartType(esbmsgPart, part);
                esbmsg.setPartArray(i, esbmsgPart);
            }
            int j = 0;
            Iterator iter = msg.getHeaderNames();
            while (iter.hasNext()) {
                String hdrName = (String)iter.next();
                Object hdrObj = msg.getHeaderValue(hdrName);
                String value = hdrObj == null ? null : hdrObj.toString();
                if (value == null || value.length() == 0) continue;
                HeaderType hdr = esbmsg.addNewHeader();
                hdr.setName(hdrName);
                hdr.setValue(value.toString());
                esbmsg.setHeaderArray(j, hdr);
                ++j;
            }
            MessageType.Enum esbMsgType = esbmsg.getType();
            String esbType = esbMsgType.toString();
            esbMsgType = msg.getPartCount() == 1 ? (esbType.equals("text/xml") ? MessageType.XML_MESSAGE : (esbType.startsWith("text/") ? MessageType.TEXT_MESSAGE : MessageType.MESSAGE)) : MessageType.MULTIPART_MESSAGE;
            esbmsg.setType(esbMsgType);
            Node esbNode = esbmsg.getDomNode();
            return esbNode.getOwnerDocument();
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException(" Cannot create Document from XQMessage ", e, ctx);
        }
    }

    private void setPartType(PartType esbmsgPart, XQPart part) {
        XmlCursor textCursor = esbmsgPart.newCursor();
        textCursor.setTextValue(part.getContent().toString());
        textCursor.dispose();
        XmlString esbmsgContID = XmlString.Factory.newValue((Object)part.getContentId());
        esbmsgPart.setContentId(esbmsgContID.getStringValue());
        XmlString esbmsgContType = XmlString.Factory.newValue((Object)part.getContentType());
        esbmsgPart.setContentType(esbmsgContType.getStringValue());
        XQHeader xqhdr = part.getHeader();
        Iterator it = xqhdr.getKeys();
        XmlCursor xmlcursor = esbmsgPart.newCursor();
        xmlcursor.toNextToken();
        while (it.hasNext()) {
            String headerName = it.next().toString();
            String headerVal = xqhdr.getValue(headerName);
            if (headerName == null || headerVal == null || headerName.equals("Content-ID") || headerName.equals("Content-Type")) continue;
            xmlcursor.insertAttributeWithValue(headerName, URI, headerVal);
        }
        xmlcursor.dispose();
    }
}

