/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.util.spring;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class DuplicateAwareApplicationContext
extends GenericApplicationContext {
    private static final Logger logger = LogManager.getLogger(DuplicateAwareApplicationContext.class);
    private final Set overriddenBeanNames = new HashSet();

    public DuplicateAwareApplicationContext() {
    }

    public DuplicateAwareApplicationContext(ApplicationContext parent) {
        super(parent);
    }

    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeansException {
        boolean dup = this.getBeanFactory().containsBean(beanName);
        super.registerBeanDefinition(beanName, beanDefinition);
        if (dup) {
            logger.debug("Bean '" + beanName + "' has been overridden with class: " + beanDefinition.getBeanClassName());
            this.overriddenBeanNames.add(beanName);
        }
    }

    public Set getOverridenBeanNames() {
        return Collections.unmodifiableSet(this.overriddenBeanNames);
    }

    public void clearHistory() {
        this.overriddenBeanNames.clear();
    }

    public void setAllowBeanDefinitionOverriding(boolean bool) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.getBeanFactory();
        beanFactory.setAllowBeanDefinitionOverriding(bool);
    }
}

