/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.service.common.SFCParameters;
import com.sonicsw.esb.service.common.SFCServiceException;
import com.sonicsw.esb.service.common.util.Check;
import com.sonicsw.esb.service.common.util.spring.ResourceUtils;
import com.sonicsw.esb.service.common.util.variables.VariableParser;
import com.sonicsw.esb.service.common.util.variables.VariableParserImpl;
import com.sonicsw.xq.XQParameterInfo;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.xml.sax.SAXException;

abstract class AbstractSFCParametersImpl
implements SFCParameters,
ResourceLoaderAware {
    protected Logger logger = Logger.getLogger(SFCParameters.class);
    protected String name;
    private boolean substitutionEnabled = true;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private VariableParser variableParser = new VariableParserImpl();

    AbstractSFCParametersImpl() {
    }

    @Override
    public boolean contains(String paramName) {
        return this.getInfo(paramName) != null;
    }

    @Override
    public String getParameter(String paramName) throws SFCServiceException {
        XQParameterInfo info = this.getInfo(paramName);
        return this.getParameter(info);
    }

    @Override
    public Object getParameterObject(String paramName) throws SFCServiceException {
        XQParameterInfo info = this.getInfo(paramName);
        return this.getParameterObject(info);
    }

    @Override
    public String getReference(String paramName) {
        XQParameterInfo info = this.getInfo(paramName);
        return this.getReference(info);
    }

    protected String getParameter(XQParameterInfo info) throws SFCServiceException {
        if (null == info) {
            return null;
        }
        if (this.isReference(info)) {
            return this.getParameterFromReference(info);
        }
        String value = info.getValue();
        return this.replaceAllVariables(value);
    }

    protected Object getParameterObject(XQParameterInfo info) throws SFCServiceException {
        if (null == info) {
            return null;
        }
        if (this.isReference(info)) {
            return this.getParamterObjectFromReference(info);
        }
        Object value = info.getValueObject();
        if (value instanceof String) {
            value = this.replaceAllVariables((String)value);
        }
        return value;
    }

    protected String getReference(XQParameterInfo info) {
        if (null == info) {
            return null;
        }
        String ref = this.getRawReference(info);
        return this.replaceAllVariables(ref);
    }

    protected boolean isReference(XQParameterInfo info) {
        return this.getRawReference(info) != null;
    }

    protected String getRawReference(XQParameterInfo info) {
        if (null == info) {
            return null;
        }
        String ref = info.getRef();
        if (ref == null || ref.length() == 0) {
            return null;
        }
        return ref;
    }

    @Override
    public String getParameter(String paramName, String defaultValue) {
        String result = null;
        try {
            result = this.getParameter(paramName);
        }
        catch (SFCServiceException excp) {
            this.logger.trace((Object)("Failed to get value for parameter '" + paramName + "', returning default"), (Throwable)((Object)excp));
        }
        return result != null ? result : defaultValue;
    }

    @Override
    public Object getParameterObject(String paramName, Object defaultValue) {
        Object result = null;
        try {
            result = this.getParameterObject(paramName);
        }
        catch (SFCServiceException excp) {
            this.logger.trace((Object)("Failed to get value for parameter '" + paramName + "', returning default"), (Throwable)((Object)excp));
        }
        return result != null ? result : defaultValue;
    }

    @Override
    public boolean getBooleanParameter(String paramName) throws SFCServiceException {
        String result = this.getParameter(paramName);
        return new Boolean(result);
    }

    @Override
    public byte getByteParameter(String paramName) throws SFCServiceException {
        String result = this.getParameter(paramName);
        try {
            return new Byte(result);
        }
        catch (NumberFormatException ex) {
            throw new InvalidParameterValueException(paramName, result, Byte.TYPE);
        }
    }

    @Override
    public double getDoubleParameter(String paramName) throws SFCServiceException {
        String result = this.getParameter(paramName);
        try {
            return new Double(result);
        }
        catch (NumberFormatException ex) {
            throw new InvalidParameterValueException(paramName, result, Double.TYPE);
        }
    }

    @Override
    public float getFloatParameter(String paramName) throws SFCServiceException {
        String result = this.getParameter(paramName);
        try {
            return new Float(result).floatValue();
        }
        catch (NumberFormatException ex) {
            throw new InvalidParameterValueException(paramName, result, Float.TYPE);
        }
    }

    @Override
    public int getIntParameter(String paramName) throws SFCServiceException {
        String result = this.getParameter(paramName);
        try {
            return new Integer(result);
        }
        catch (NumberFormatException ex) {
            throw new InvalidParameterValueException(paramName, result, Integer.TYPE);
        }
    }

    @Override
    public long getLongParameter(String paramName) throws SFCServiceException {
        String result = this.getParameter(paramName);
        try {
            return new Long(result);
        }
        catch (NumberFormatException ex) {
            throw new InvalidParameterValueException(paramName, result, Long.TYPE);
        }
    }

    @Override
    public short getShortParameter(String paramName) throws SFCServiceException {
        String result = this.getParameter(paramName);
        try {
            return new Short(result);
        }
        catch (NumberFormatException ex) {
            throw new InvalidParameterValueException(paramName, result, Short.TYPE);
        }
    }

    @Override
    public InputStream readReference(String paramName) throws SFCServiceException {
        String reference = this.getReference(paramName);
        if (reference == null) {
            return null;
        }
        Resource resource = this.resourceLoader.getResource(reference);
        try {
            return resource.getInputStream();
        }
        catch (IOException excp) {
            throw new InvalidParameterReferenceException(paramName, reference, excp);
        }
    }

    private String getParameterFromReference(XQParameterInfo info) throws SFCServiceException {
        String ref = this.replaceAllVariables(info.getRef());
        if (null == ref) {
            return null;
        }
        try {
            Resource resource = this.resourceLoader.getResource(ref);
            byte[] data = ResourceUtils.getContents(resource);
            return new String(data);
        }
        catch (IOException excp) {
            throw new InvalidParameterReferenceException(info.getName(), ref, excp);
        }
    }

    private Object getParamterObjectFromReference(XQParameterInfo info) throws SFCServiceException {
        switch (info.getType()) {
            case 1: {
                return this.getParameterFromReference(info);
            }
            case 2: {
                String ref = this.replaceAllVariables(info.getRef());
                if (null == ref) {
                    return null;
                }
                try {
                    Resource resource = this.resourceLoader.getResource(ref);
                    return ResourceUtils.parseContents(resource);
                }
                catch (IOException excp) {
                    throw new InvalidParameterReferenceException(info.getName(), ref, excp);
                }
                catch (SAXException excp) {
                    throw new ParameterParseException(info.getName(), ref, excp);
                }
            }
        }
        throw new IllegalArgumentException("Unsupported parameter type: " + info.getType());
    }

    @Override
    public void writeToLog() {
        this.writeToLog(this.logger, Level.INFO);
    }

    public void writeToLog(Logger logger, Level level) {
        if (logger.isEnabledFor((Priority)level)) {
            MessageFormat pattern = new MessageFormat("Parameter: {0} = {1}");
            Map map = this.getXQParameters().getAllInfo();
            for (XQParameterInfo info : map.values()) {
                String name = info.getName();
                Object val = "<unknown>";
                if (this.isReference(info)) {
                    val = "<from file: " + info.getRef() + ">";
                } else {
                    try {
                        val = this.getParameter(name);
                        if (val == null) {
                            val = this.getParameterObject(name);
                        }
                    }
                    catch (SFCServiceException excp) {
                        logger.trace((Object)"Unable to log parameter value", (Throwable)((Object)excp));
                    }
                }
                logger.log((Priority)level, (Object)pattern.format(new Object[]{name, val}));
            }
        }
    }

    @Override
    public void enableSubstitution() {
        Check.isSet(this.variableParser, "variableParser");
        this.substitutionEnabled = true;
    }

    @Override
    public void disableSubstitution() {
        this.substitutionEnabled = false;
    }

    @Override
    public boolean isSubstitutionEnabled() {
        return this.substitutionEnabled;
    }

    private String replaceAllVariables(String content) {
        if (this.substitutionEnabled && this.variableParser != null) {
            return this.variableParser.replaceAllVariables(content);
        }
        return content;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        if (name != null && name.length() > 0) {
            this.logger = Logger.getLogger((String)(SFCParameters.class.getName() + "." + name));
        }
    }

    public final void setVariableParser(VariableParser variableParser) {
        if (variableParser == null) {
            this.disableSubstitution();
        }
        this.variableParser = variableParser;
    }

    private class ParameterParseException
    extends SFCServiceException {
        public ParameterParseException(String paramName, String reference, Throwable cause) {
            super("Failed to parse contents of reference '" + reference + "' for parameter '" + paramName + "'", cause);
        }
    }

    private class InvalidParameterReferenceException
    extends SFCServiceException {
        public InvalidParameterReferenceException(String paramName, String reference, Throwable cause) {
            super("Failed to read reference '" + reference + "' for parameter '" + paramName + "'", cause);
        }
    }

    private class InvalidParameterValueException
    extends SFCServiceException {
        public InvalidParameterValueException(String paramName, String value, Class expectedType) {
            super("Invalid parameter '" + paramName + "'. Cannot convert value '" + value + "' to " + expectedType.getName() + ".");
        }
    }
}

