/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.service.common.SFCServiceContext;
import com.sonicsw.esb.service.common.impl.ContextAwareVariableResolver;
import com.sonicsw.esb.service.common.util.CheckArg;
import com.sonicsw.esb.service.common.util.variables.VariableFactory;
import com.sonicsw.esb.service.common.util.variables.VariableResolver;
import com.sonicsw.xq.XQProcessContext;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ProcessContextVariableResolver
implements ContextAwareVariableResolver,
VariableFactory {
    private static final Logger logger = Logger.getLogger((String)(VariableResolver.class.getName() + '.' + "esbp"));
    private XQProcessContext context;

    public ProcessContextVariableResolver() {
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException excp) {
            throw new IllegalStateException(excp.getMessage());
        }
    }

    public String getScheme() {
        return "esbp";
    }

    public ProcessContextVariableResolver(XQProcessContext context) {
        this.context = context;
    }

    @Override
    public final void setContext(SFCServiceContext context) {
        this.setProcessContext(context.getProcessContext());
    }

    public final void setProcessContext(XQProcessContext context) {
        this.context = context;
    }

    @Override
    public String resolve(String variableStr) {
        CheckArg.notNull(variableStr, "variableStr");
        if (this.context == null) {
            throw new IllegalStateException("Cannot resolve variable '" + variableStr + "' - there is no current ESB Process context.");
        }
        try {
            ProcessContextVariable var = (ProcessContextVariable)this.getVariable(variableStr);
            if (var.type.equals(ProcessContextVariable.CONTEXT)) {
                return this.resolveContext(var.getSource());
            }
            if (var.type.equals(ProcessContextVariable.PROPERTY)) {
                return this.resolveInflightProperty(var.getSource());
            }
            throw new IllegalStateException("Unsupported process context variable type: " + var.getType());
        }
        catch (Exception excp) {
            return null;
        }
    }

    private String resolveContext(String artifactName) {
        return null;
    }

    private String resolveInflightProperty(String propName) {
        Properties props = this.context.getInflightProperties();
        return props != null ? props.getProperty(propName) : null;
    }

    @Override
    public VariableFactory.Variable getVariable(String variableStr) {
        return new ProcessContextVariable(variableStr);
    }

    public VariableFactory.Variable createInflightPropsVariable(String property) {
        return new ProcessContextVariable(ProcessContextVariable.PROPERTY, property);
    }

    public VariableFactory.Variable createContextVariable(String artifact) {
        return new ProcessContextVariable(ProcessContextVariable.CONTEXT, artifact);
    }

    public static class ProcessContextVariable
    implements VariableFactory.Variable {
        public static final Type PROPERTY = new Type("props");
        public static final Type CONTEXT = new Type("context");
        public static final String SCHEME = "esbp";
        private final Type type;
        private final String variableStr;
        private final String source;

        ProcessContextVariable(String variableStr) {
            StringTokenizer parts = new StringTokenizer(variableStr, ":");
            if (parts.countTokens() != 3 || !SCHEME.equals(parts.nextToken())) {
                throw new IllegalArgumentException("Malformed process context variable string: '" + variableStr + "'. Expected format is 'esbp:type:source'.");
            }
            this.type = this.typeFromString(parts.nextToken());
            this.source = parts.nextToken();
            this.variableStr = variableStr;
        }

        ProcessContextVariable(Type type, String source) {
            CheckArg.notNull(type, "type");
            CheckArg.notEmpty(source, "source");
            this.type = type;
            this.source = source;
            this.variableStr = "esbp:" + type.name + ':' + source;
        }

        public Type getType() {
            return this.type;
        }

        public String getSource() {
            return this.source;
        }

        public String toString() {
            return this.variableStr;
        }

        private Type typeFromString(String str) {
            if (ProcessContextVariable.CONTEXT.name.equals(str)) {
                return CONTEXT;
            }
            if (ProcessContextVariable.PROPERTY.name.equals(str)) {
                return PROPERTY;
            }
            throw new IllegalArgumentException("Unsupported esbmsg variable type: " + str);
        }

        public static final class Type {
            protected String name;

            private Type(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

