/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.service.common.impl.AbstractSFCServiceImpl;
import com.sonicsw.esb.service.common.impl.SFCServiceEnvironment;
import com.sonicsw.esb.service.common.util.Check;
import java.beans.PropertyDescriptor;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SFCServiceBeanProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private final Logger logger = Logger.getLogger(this.getClass());
    private ApplicationContext applicationContext;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean != null && AbstractSFCServiceImpl.class.isAssignableFrom(bean.getClass())) {
            this.logger.debug((Object)("Found SFCService bean: " + bean));
            Check.isSet(this.applicationContext, "applicationContext");
            SFCServiceEnvironment env = (SFCServiceEnvironment)this.applicationContext.getBean("sfcServiceEnvironment");
            BeanWrapperImpl envWrapper = new BeanWrapperImpl((Object)env);
            BeanWrapperImpl serviceWrapper = new BeanWrapperImpl(bean);
            PropertyDescriptor[] properties = envWrapper.getPropertyDescriptors();
            for (int i = 0; i < properties.length; ++i) {
                String name = properties[i].getName();
                Object value = envWrapper.getPropertyValue(name);
                if (value == null || !serviceWrapper.isWritableProperty(name)) continue;
                serviceWrapper.setPropertyValue(name, value);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("set " + name + " = " + value));
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

